/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.dispenser.BoatDispenseBehavior;
import cn.nukkit.dispenser.BucketDispenseBehavior;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.dispenser.DispenseBehavior;
import cn.nukkit.dispenser.DyeDispenseBehavior;
import cn.nukkit.dispenser.FireworksDispenseBehavior;
import cn.nukkit.dispenser.FlintAndSteelDispenseBehavior;
import cn.nukkit.dispenser.ProjectileDispenseBehavior;
import cn.nukkit.dispenser.ShulkerBoxDispenseBehavior;
import cn.nukkit.dispenser.SpawnEggDispenseBehavior;
import cn.nukkit.dispenser.TNTDispenseBehavior;
import java.util.HashMap;
import java.util.Map;

public final class DispenseBehaviorRegister {
    private static final Map<Integer, DispenseBehavior> behaviors = new HashMap<Integer, DispenseBehavior>();
    private static DispenseBehavior defaultBehavior = new DefaultDispenseBehavior();

    public static void registerBehavior(int itemId, DispenseBehavior behavior) {
        behaviors.put(itemId, behavior);
    }

    public static DispenseBehavior getBehavior(int id) {
        return behaviors.getOrDefault(id, defaultBehavior);
    }

    public static void removeDispenseBehavior(int id) {
        behaviors.remove(id);
    }

    @PowerNukkitOnly
    public static void init() {
        DispenseBehaviorRegister.registerBehavior(333, new BoatDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(325, new BucketDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(351, new DyeDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(401, new FireworksDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(259, new FlintAndSteelDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(218, new ShulkerBoxDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(205, new ShulkerBoxDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(383, new SpawnEggDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(46, new TNTDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(262, new ProjectileDispenseBehavior("Arrow"){

            @Override
            protected double getMotion() {
                return super.getMotion() * 1.5;
            }
        });
        DispenseBehaviorRegister.registerBehavior(344, new ProjectileDispenseBehavior("Egg"));
        DispenseBehaviorRegister.registerBehavior(332, new ProjectileDispenseBehavior("Snowball"));
        DispenseBehaviorRegister.registerBehavior(384, new ProjectileDispenseBehavior("ThrownExpBottle"){

            @Override
            protected float getAccuracy() {
                return super.getAccuracy() * 0.5f;
            }

            @Override
            protected double getMotion() {
                return super.getMotion() * 1.25;
            }
        });
        DispenseBehaviorRegister.registerBehavior(438, new ProjectileDispenseBehavior("ThrownPotion"){

            @Override
            protected float getAccuracy() {
                return super.getAccuracy() * 0.5f;
            }

            @Override
            protected double getMotion() {
                return super.getMotion() * 1.25;
            }
        });
        DispenseBehaviorRegister.registerBehavior(455, new ProjectileDispenseBehavior("ThrownTrident"){

            @Override
            protected float getAccuracy() {
                return super.getAccuracy() * 0.5f;
            }

            @Override
            protected double getMotion() {
                return super.getMotion() * 1.25;
            }
        });
    }
}

