/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDispenser;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;

@PowerNukkitOnly
public class FlintAndSteelDispenseBehavior
extends DefaultDispenseBehavior {
    @PowerNukkitOnly
    public FlintAndSteelDispenseBehavior() {
    }

    @Override
    @PowerNukkitDifference(info="Reduce flint and steel usage instead of clearing.", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public Item dispense(BlockDispenser block, BlockFace face, Item item) {
        Block target = block.getSide(face);
        item = item.clone();
        if (target.getId() == 0) {
            block.level.addSound(block, Sound.RANDOM_CLICK, 1.0f, 1.0f);
            block.level.setBlock(target, Block.get(51));
            item.useOn(target);
            return item.getDamage() >= item.getMaxDurability() ? null : item;
        }
        if (target.getId() == 46) {
            block.level.addSound(block, Sound.RANDOM_CLICK, 1.0f, 1.0f);
            target.onActivate(item);
            item.useOn(target);
            return item.getDamage() >= item.getMaxDurability() ? null : item;
        }
        this.success = false;
        block.level.addSound(block, Sound.RANDOM_CLICK, 1.0f, 1.2f);
        return item;
    }
}

