/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityHuman;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.data.FloatEntityData;
import cn.nukkit.entity.item.EntityVehicle;
import cn.nukkit.entity.passive.EntityWaterAnimal;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.vehicle.VehicleMoveEvent;
import cn.nukkit.event.vehicle.VehicleUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Location;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.math.Vector3f;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.AnimatePacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.types.EntityLink;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EntityBoat
extends EntityVehicle {
    public static final int NETWORK_ID = 90;
    public static final Vector3f RIDER_PLAYER_OFFSET = new Vector3f(0.0f, 1.02001f, 0.0f);
    public static final Vector3f RIDER_OFFSET = new Vector3f(0.0f, -0.2f, 0.0f);
    public static final Vector3f PASSENGER_OFFSET = new Vector3f(-0.6f);
    public static final Vector3f RIDER_PASSENGER_OFFSET = new Vector3f(0.2f);
    public static final int RIDER_INDEX = 0;
    public static final int PASSENGER_INDEX = 1;
    public static final double SINKING_DEPTH = 0.07;
    public static final double SINKING_SPEED = 5.0E-4;
    public static final double SINKING_MAX_SPEED = 0.005;
    protected boolean sinking = true;
    private int ticksInWater;
    private final Set<Entity> ignoreCollision = new HashSet<Entity>(2);
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Unreliable direct field access", replaceWith="getVariant(), setVariant(int)")
    @Since(value="1.4.0.0-PN")
    public int woodID;

    public EntityBoat(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
        this.setMaxHealth(40);
        this.setHealth(40.0f);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        if (this.namedTag.contains("Variant")) {
            this.woodID = this.namedTag.getInt("Variant");
        } else if (this.namedTag.contains("woodID")) {
            this.woodID = this.namedTag.getByte("woodID");
        }
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_GRAVITY, true);
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_STACKABLE, true);
        this.dataProperties.putInt(DATA_VARIANT, this.woodID);
        this.dataProperties.putBoolean(DATA_IS_BUOYANT, true);
        this.dataProperties.putString(DATA_BUOYANCY_DATA, "{\"apply_gravity\":true,\"base_buoyancy\":1.0,\"big_wave_probability\":0.02999999932944775,\"big_wave_speed\":10.0,\"drag_down_on_buoyancy_removed\":0.0,\"liquid_blocks\":[\"minecraft:water\",\"minecraft:flowing_water\"],\"simulate_waves\":true}");
        this.dataProperties.putInt(DATA_MAX_AIR, 300);
        this.dataProperties.putLong(DATA_OWNER_EID, -1L);
        this.dataProperties.putFloat(DATA_PADDLE_TIME_LEFT, 0.0f);
        this.dataProperties.putFloat(DATA_PADDLE_TIME_RIGHT, 0.0f);
        this.dataProperties.putByte(DATA_CONTROLLING_RIDER_SEAT_NUMBER, 0);
        this.dataProperties.putInt(DATA_LIMITED_LIFE, -1);
        this.dataProperties.putByte(DATA_ALWAYS_SHOW_NAMETAG, -1);
        this.dataProperties.putFloat(DATA_AMBIENT_SOUND_INTERVAL, 8.0f);
        this.dataProperties.putFloat(DATA_AMBIENT_SOUND_INTERVAL_RANGE, 16.0f);
        this.dataProperties.putString(DATA_AMBIENT_SOUND_EVENT_NAME, "ambient");
        this.dataProperties.putFloat(DATA_FALL_DAMAGE_MULTIPLIER, 1.0f);
        this.entityCollisionReduction = -0.5;
    }

    @Override
    public float getHeight() {
        return 0.455f;
    }

    @Override
    public float getWidth() {
        return 1.4f;
    }

    @Override
    protected float getDrag() {
        return 0.1f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    public float getBaseOffset() {
        return 0.375f;
    }

    @Override
    public int getNetworkId() {
        return 90;
    }

    @Override
    public String getInteractButtonText() {
        return "action.interact.ride.boat";
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        if (this.invulnerable) {
            return false;
        }
        source.setDamage(source.getDamage() * 2.0f);
        boolean attack = super.attack(source);
        if (this.isAlive()) {
            this.performHurtAnimation();
        }
        return attack;
    }

    @Override
    public void close() {
        super.close();
        for (Entity linkedEntity : this.passengers) {
            linkedEntity.riding = null;
        }
    }

    @Override
    protected DataPacket createAddEntityPacket() {
        AddEntityPacket addEntity = new AddEntityPacket();
        addEntity.type = 0;
        addEntity.id = "minecraft:boat";
        addEntity.entityUniqueId = this.getId();
        addEntity.entityRuntimeId = this.getId();
        addEntity.yaw = (float)this.yaw;
        addEntity.headYaw = (float)this.yaw;
        addEntity.pitch = (float)this.pitch;
        addEntity.x = (float)this.x;
        addEntity.y = (float)this.y + this.getBaseOffset();
        addEntity.z = (float)this.z;
        addEntity.speedX = (float)this.motionX;
        addEntity.speedY = (float)this.motionY;
        addEntity.speedZ = (float)this.motionZ;
        addEntity.metadata = this.dataProperties;
        addEntity.links = new EntityLink[this.passengers.size()];
        for (int i = 0; i < addEntity.links.length; ++i) {
            addEntity.links[i] = new EntityLink(this.getId(), ((Entity)this.passengers.get(i)).getId(), i == 0 ? (byte)1 : 2, false, false);
        }
        return addEntity;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            hasUpdate = this.updateBoat(tickDiff) || hasUpdate;
        }
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    private boolean updateBoat(int tickDiff) {
        if (this.getRollingAmplitude() > 0) {
            this.setRollingAmplitude(this.getRollingAmplitude() - 1);
        }
        if (this.y < -16.0) {
            this.kill();
            return false;
        }
        boolean hasUpdated = false;
        double waterDiff = this.getWaterLevel();
        if (!this.hasControllingPassenger()) {
            hasUpdated = this.computeBuoyancy(waterDiff);
            Iterator<Entity> iterator = this.ignoreCollision.iterator();
            while (iterator.hasNext()) {
                Entity ignored = iterator.next();
                if (ignored.isValid() && !ignored.isClosed() && ignored.isAlive() && ignored.getBoundingBox().intersectsWith(this.getBoundingBox().grow(0.5, 0.5, 0.5))) continue;
                iterator.remove();
                hasUpdated = true;
            }
            this.moveBoat(waterDiff);
        } else {
            this.updateMovement();
        }
        boolean bl = hasUpdated = hasUpdated || this.positionChanged;
        if (waterDiff >= -0.07) {
            if (this.ticksInWater != 0) {
                this.ticksInWater = 0;
                hasUpdated = true;
            }
        } else {
            hasUpdated = true;
            this.ticksInWater += tickDiff;
            if (this.ticksInWater >= 60) {
                for (int i = this.passengers.size() - 1; i >= 0; --i) {
                    this.dismountEntity((Entity)this.passengers.get(i));
                }
            }
        }
        this.getServer().getPluginManager().callEvent(new VehicleUpdateEvent(this));
        return hasUpdated;
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return super.canCollideWith(entity) && !this.isPassenger(entity);
    }

    @Override
    public boolean canDoInteraction() {
        return this.passengers.size() < 2;
    }

    private void moveBoat(double waterDiff) {
        this.checkObstruction(this.x, this.y, this.z);
        this.move(this.motionX, this.motionY, this.motionZ);
        double friction = 1.0f - this.getDrag();
        if (this.onGround && (Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5)) {
            friction *= this.getLevel().getBlock(this.temporalVector.setComponents((int)Math.floor(this.x), (int)Math.floor(this.y - 1.0), (int)Math.floor(this.z) - 1)).getFrictionFactor();
        }
        this.motionX *= friction;
        if (!this.onGround || waterDiff > 0.07) {
            this.motionY = waterDiff > 0.5 ? this.motionY - (double)this.getGravity() : (this.motionY - 5.0E-4 < -0.005 ? this.motionY : this.motionY - 5.0E-4);
        }
        this.motionZ *= friction;
        Location from = new Location(this.lastX, this.lastY, this.lastZ, this.lastYaw, this.lastPitch, this.level);
        Location to = new Location(this.x, this.y, this.z, this.yaw, this.pitch, this.level);
        if (!from.equals(to)) {
            this.getServer().getPluginManager().callEvent(new VehicleMoveEvent(this, from, to));
        }
        this.updateMovement();
    }

    private boolean collectCollidingEntities() {
        if (this.passengers.size() >= 2) {
            return false;
        }
        for (Entity entity : this.level.getCollidingEntities(this.boundingBox.grow(0.2f, 0.0, 0.2f), this)) {
            if (entity.riding != null || !(entity instanceof EntityLiving) || entity instanceof Player || entity instanceof EntityWaterAnimal || this.isPassenger(entity)) continue;
            this.mountEntity(entity);
            if (this.passengers.size() >= 2) break;
        }
        return true;
    }

    private boolean computeBuoyancy(double waterDiff) {
        boolean hasUpdated = false;
        if ((waterDiff -= (double)(this.getBaseOffset() / 4.0f)) > 0.07 && !this.sinking) {
            this.sinking = true;
        } else if (waterDiff < -0.07 && this.sinking) {
            this.sinking = false;
        }
        if (waterDiff < -0.0411764705882353) {
            this.motionY = Math.min(0.005, this.motionY + 0.005);
            hasUpdated = true;
        } else if (waterDiff < 0.0 || !this.sinking) {
            this.motionY = this.motionY > 0.0025 ? Math.max(this.motionY - 0.02, 0.0025) : this.motionY + 5.0E-4;
            hasUpdated = true;
        }
        return hasUpdated;
    }

    @Override
    public void updatePassengers() {
        this.updatePassengers(false);
    }

    public void updatePassengers(boolean sendLinks) {
        Entity ent;
        if (this.passengers.isEmpty()) {
            return;
        }
        for (Entity passenger : new ArrayList(this.passengers)) {
            if (passenger.isAlive()) continue;
            this.dismountEntity(passenger);
        }
        if (this.passengers.size() == 1) {
            ent = (Entity)this.passengers.get(0);
            ent.setSeatPosition(this.getMountedOffset(ent));
            super.updatePassengerPosition(ent);
            if (sendLinks) {
                this.broadcastLinkPacket(ent, (byte)1);
            }
        } else if (this.passengers.size() == 2) {
            Entity passenger2;
            ent = (Entity)this.passengers.get(0);
            if (!(ent instanceof Player) && (passenger2 = (Entity)this.passengers.get(1)) instanceof Player) {
                this.passengers.set(0, passenger2);
                this.passengers.set(1, ent);
                ent = passenger2;
            }
            ent.setSeatPosition(this.getMountedOffset(ent).add(RIDER_PASSENGER_OFFSET));
            super.updatePassengerPosition(ent);
            if (sendLinks) {
                this.broadcastLinkPacket(ent, (byte)1);
            }
            ent = (Entity)this.passengers.get(1);
            ent.setSeatPosition(this.getMountedOffset(ent).add(PASSENGER_OFFSET));
            super.updatePassengerPosition(ent);
            if (sendLinks) {
                this.broadcastLinkPacket(ent, (byte)2);
            }
        } else {
            for (Entity passenger : this.passengers) {
                super.updatePassengerPosition(passenger);
            }
        }
    }

    public double getWaterLevel() {
        final double maxY = this.boundingBox.getMinY() + (double)this.getBaseOffset();
        AxisAlignedBB.BBConsumer<Double> consumer = new AxisAlignedBB.BBConsumer<Double>(){
            private double diffY = Double.MAX_VALUE;

            @Override
            public void accept(int x, int y, int z) {
                Block block = EntityBoat.this.level.getBlock(EntityBoat.this.temporalVector.setComponents(x, y, z));
                if (block instanceof BlockWater || (block = block.getLevelBlockAtLayer(1)) instanceof BlockWater) {
                    double level = block.getMaxY();
                    this.diffY = Math.min(maxY - level, this.diffY);
                }
            }

            @Override
            public Double get() {
                return this.diffY;
            }
        };
        this.boundingBox.forEach(consumer);
        return (Double)consumer.get();
    }

    @Override
    public boolean mountEntity(Entity entity) {
        boolean player = this.passengers.size() >= 1 && this.passengers.get(0) instanceof Player;
        byte mode = 2;
        if (!player && (entity instanceof Player || this.passengers.size() == 0)) {
            mode = 1;
        }
        return super.mountEntity(entity, mode);
    }

    @Override
    public boolean mountEntity(Entity entity, byte mode) {
        boolean r = super.mountEntity(entity, mode);
        if (entity.riding == this) {
            this.updatePassengers(true);
            entity.setDataProperty(new ByteEntityData(DATA_RIDER_ROTATION_LOCKED, 1));
            entity.setDataProperty(new FloatEntityData(DATA_RIDER_MAX_ROTATION, 90.0f));
            entity.setDataProperty(new FloatEntityData(DATA_RIDER_MIN_ROTATION, this.passengers.indexOf(entity) == 1 ? -90.0f : 1.0f));
            entity.setDataProperty(new FloatEntityData(DATA_RIDER_ROTATION_OFFSET, -90.0f));
            entity.setRotation(this.yaw, entity.pitch);
            entity.updateMovement();
        }
        return r;
    }

    @Override
    protected void updatePassengerPosition(Entity passenger) {
        this.updatePassengers();
    }

    @Override
    public boolean dismountEntity(Entity entity) {
        boolean r = super.dismountEntity(entity);
        this.updatePassengers();
        entity.setDataProperty(new ByteEntityData(DATA_RIDER_ROTATION_LOCKED, 0));
        if (entity instanceof EntityHuman) {
            this.ignoreCollision.add(entity);
        }
        return r;
    }

    @Override
    public boolean isControlling(Entity entity) {
        return entity instanceof Player && this.passengers.indexOf(entity) == 0;
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (this.passengers.size() >= 2 || this.getWaterLevel() < -0.07) {
            return false;
        }
        super.mountEntity(player);
        return super.onInteract(player, item, clickedPos);
    }

    @Override
    public Vector3f getMountedOffset(Entity entity) {
        return entity instanceof Player ? RIDER_PLAYER_OFFSET : RIDER_OFFSET;
    }

    public void onPaddle(AnimatePacket.Action animation, float value) {
        int propertyId;
        int n = propertyId = animation == AnimatePacket.Action.ROW_RIGHT ? DATA_PADDLE_TIME_RIGHT : DATA_PADDLE_TIME_LEFT;
        if (Float.compare(this.getDataPropertyFloat(propertyId), value) != 0) {
            this.setDataProperty(new FloatEntityData(propertyId, value));
        }
    }

    @Override
    public void applyEntityCollision(Entity entity) {
        if (!(this.riding != null || this.hasControllingPassenger() || entity.riding == this || entity.passengers.contains(this) || this.ignoreCollision.contains(entity))) {
            if (!entity.boundingBox.intersectsWith(this.boundingBox.grow(0.2f, -0.1, 0.2f)) || entity instanceof Player && ((Player)entity).isSpectator()) {
                return;
            }
            double diffX = entity.x - this.x;
            double diffZ = entity.z - this.z;
            double direction = NukkitMath.getDirection(diffX, diffZ);
            if (direction >= (double)0.01f) {
                direction = Math.sqrt(direction);
                diffX /= direction;
                diffZ /= direction;
                double d3 = Math.min(1.0 / direction, 1.0);
                diffX *= d3;
                diffZ *= d3;
                diffX *= (double)0.05f;
                diffZ *= (double)0.05f;
                diffX *= 1.0 + this.entityCollisionReduction;
                diffZ *= 1.0 + this.entityCollisionReduction;
                if (this.riding == null) {
                    this.motionX -= diffX;
                    this.motionZ -= diffZ;
                }
            }
        }
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    @PowerNukkitDifference(info="Fixes a dupe issue when attacking too quickly", since="1.3.1.2-PN")
    public void kill() {
        if (!this.isAlive()) {
            return;
        }
        super.kill();
        if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
            this.level.dropItem(this, Item.get(333, this.woodID));
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putInt("Variant", this.woodID);
        this.namedTag.putByte("woodID", this.woodID);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getVariant() {
        return this.woodID;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setVariant(int variant) {
        this.woodID = variant;
        this.dataProperties.putInt(DATA_VARIANT, variant);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public String getOriginalName() {
        return "Boat";
    }

    public void onInput(double x, double y, double z, double yaw) {
        this.setPositionAndRotation(this.temporalVector.setComponents(x, y - (double)this.getBaseOffset(), z), yaw % 360.0, 0.0);
    }
}

