/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.ItemDespawnEvent;
import cn.nukkit.event.entity.ItemSpawnEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.AddItemEntityPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.EntityEventPacket;

public class EntityItem
extends Entity {
    public static final int NETWORK_ID = 64;
    protected String owner;
    protected String thrower;
    protected Item item;
    protected int pickupDelay;

    public EntityItem(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public int getNetworkId() {
        return 64;
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getLength() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.25f;
    }

    @Override
    public float getGravity() {
        return 0.04f;
    }

    @Override
    public float getDrag() {
        return 0.02f;
    }

    @Override
    protected float getBaseOffset() {
        return 0.125f;
    }

    @Override
    public boolean canCollide() {
        return false;
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.setMaxHealth(5);
        this.setHealth(this.namedTag.getShort("Health"));
        if (this.namedTag.contains("Age")) {
            this.age = this.namedTag.getShort("Age");
        }
        if (this.namedTag.contains("PickupDelay")) {
            this.pickupDelay = this.namedTag.getShort("PickupDelay");
        }
        if (this.namedTag.contains("Owner")) {
            this.owner = this.namedTag.getString("Owner");
        }
        if (this.namedTag.contains("Thrower")) {
            this.thrower = this.namedTag.getString("Thrower");
        }
        if (!this.namedTag.contains("Item")) {
            this.close();
            return;
        }
        this.item = NBTIO.getItemHelper(this.namedTag.getCompound("Item"));
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_GRAVITY, true);
        if (this.item.isLavaResistant()) {
            this.fireProof = true;
        }
        this.server.getPluginManager().callEvent(new ItemSpawnEvent(this));
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Netherite stuff is immune to fire and lava damage")
    public boolean attack(EntityDamageEvent source) {
        if (this.item != null && this.item.isLavaResistant() && (source.getCause() == EntityDamageEvent.DamageCause.LAVA || source.getCause() == EntityDamageEvent.DamageCause.FIRE || source.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK)) {
            return false;
        }
        return !(source.getCause() != EntityDamageEvent.DamageCause.VOID && source.getCause() != EntityDamageEvent.DamageCause.CONTACT && source.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK && (source.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && source.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || this.isInsideOfWater() || this.item != null && this.item.getId() == 399) || !super.attack(source));
    }

    @Override
    public boolean onUpdate(int currentTick) {
        boolean lavaResistant;
        if (this.closed) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        this.timing.startTiming();
        if (this.age % 60 == 0 && this.onGround && this.getItem() != null && this.isAlive() && this.getItem().getCount() < this.getItem().getMaxStackSize()) {
            for (Entity entity : this.getLevel().getNearbyEntities(this.getBoundingBox().grow(1.0, 1.0, 1.0), this, false)) {
                int newAmount;
                Item closeItem;
                if (!(entity instanceof EntityItem) || !entity.isAlive() || !(closeItem = ((EntityItem)entity).getItem()).equals(this.getItem(), true, true) || !entity.isOnGround() || (newAmount = this.getItem().getCount() + closeItem.getCount()) > this.getItem().getMaxStackSize()) continue;
                entity.close();
                this.getItem().setCount(newAmount);
                EntityEventPacket packet = new EntityEventPacket();
                packet.eid = this.getId();
                packet.data = newAmount;
                packet.event = 69;
                Server.broadcastPacket(this.getViewers().values(), (DataPacket)packet);
            }
        }
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        boolean bl = lavaResistant = this.fireProof || this.item != null && this.item.isLavaResistant();
        if (!lavaResistant && (this.isInsideOfFire() || this.isInsideOfLava())) {
            this.kill();
        }
        if (this.isAlive()) {
            int bid;
            if (this.pickupDelay > 0 && this.pickupDelay < Short.MAX_VALUE) {
                this.pickupDelay -= tickDiff;
                if (this.pickupDelay < 0) {
                    this.pickupDelay = 0;
                }
            }
            this.motionY = (bid = this.level.getBlockIdAt((int)this.x, (int)this.boundingBox.getMaxY(), (int)this.z, 0)) == 8 || bid == 9 || (bid = this.level.getBlockIdAt((int)this.x, (int)this.boundingBox.getMaxY(), (int)this.z, 1)) == 8 || bid == 9 ? (this.motionY -= (double)this.getGravity() * -0.015) : (lavaResistant && (this.level.getBlockIdAt((int)this.x, (int)this.boundingBox.getMaxY(), (int)this.z, 0) == 10 || this.level.getBlockIdAt((int)this.x, (int)this.boundingBox.getMaxY(), (int)this.z, 0) == 11 || this.level.getBlockIdAt((int)this.x, (int)this.boundingBox.getMaxY(), (int)this.z, 1) == 10 || this.level.getBlockIdAt((int)this.x, (int)this.boundingBox.getMaxY(), (int)this.z, 1) == 11) ? (this.motionY -= (double)this.getGravity() * -0.015) : (this.isInsideOfWater() || lavaResistant && this.isInsideOfLava() ? (double)this.getGravity() - 0.06 : (this.motionY -= (double)this.getGravity())));
            if (this.checkObstruction(this.x, this.y, this.z)) {
                hasUpdate = true;
            }
            this.move(this.motionX, this.motionY, this.motionZ);
            double friction = 1.0f - this.getDrag();
            if (this.onGround && (Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5)) {
                friction *= this.getLevel().getBlock(this.temporalVector.setComponents((int)Math.floor(this.x), (int)Math.floor(this.y - 1.0), (int)Math.floor(this.z) - 1)).getFrictionFactor();
            }
            this.motionX *= friction;
            this.motionY *= (double)(1.0f - this.getDrag());
            this.motionZ *= friction;
            if (this.onGround) {
                this.motionY *= -0.5;
            }
            this.updateMovement();
            if (this.age > 6000) {
                ItemDespawnEvent ev = new ItemDespawnEvent(this);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    this.age = 0;
                } else {
                    this.kill();
                    hasUpdate = true;
                }
            }
        }
        this.timing.stopTiming();
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    @Override
    public void setOnFire(int seconds) {
        if (this.item != null && this.item.isLavaResistant()) {
            return;
        }
        super.setOnFire(seconds);
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        if (this.item != null) {
            this.namedTag.putCompound("Item", NBTIO.putItemHelper(this.item, -1));
            this.namedTag.putShort("Health", (int)this.getHealth());
            this.namedTag.putShort("Age", this.age);
            this.namedTag.putShort("PickupDelay", this.pickupDelay);
            if (this.owner != null) {
                this.namedTag.putString("Owner", this.owner);
            }
            if (this.thrower != null) {
                this.namedTag.putString("Thrower", this.thrower);
            }
        }
    }

    @Override
    @Since(value="1.5.1.0-PN")
    @PowerNukkitOnly
    public String getOriginalName() {
        return "Item";
    }

    @Override
    public String getName() {
        if (this.hasCustomName()) {
            return this.getNameTag();
        }
        if (this.item == null) {
            return this.getOriginalName();
        }
        return this.item.count + "x " + (this.item.hasCustomName() ? this.item.getCustomName() : this.item.getName());
    }

    public Item getItem() {
        return this.item;
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public int getPickupDelay() {
        return this.pickupDelay;
    }

    public void setPickupDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getThrower() {
        return this.thrower;
    }

    public void setThrower(String thrower) {
        this.thrower = thrower;
    }

    @Override
    public DataPacket createAddEntityPacket() {
        AddItemEntityPacket addEntity = new AddItemEntityPacket();
        addEntity.entityUniqueId = this.getId();
        addEntity.entityRuntimeId = this.getId();
        addEntity.x = (float)this.x;
        addEntity.y = (float)this.y;
        addEntity.z = (float)this.z;
        addEntity.speedX = (float)this.motionX;
        addEntity.speedY = (float)this.motionY;
        addEntity.speedZ = (float)this.motionZ;
        addEntity.metadata = this.dataProperties;
        addEntity.item = this.getItem();
        return addEntity;
    }

    @Override
    public boolean doesTriggerPressurePlate() {
        return true;
    }
}

