/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.mob;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.mob.EntityMob;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.concurrent.ThreadLocalRandom;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class EntityIronGolem
extends EntityMob {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int NETWORK_ID = 20;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public EntityIronGolem(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public int getNetworkId() {
        return 20;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public String getOriginalName() {
        return "Iron Golem";
    }

    @Override
    public float getWidth() {
        return 1.4f;
    }

    @Override
    public float getHeight() {
        return 2.9f;
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.setMaxHealth(100);
        this.setHealth(100.0f);
    }

    @Override
    public Item[] getDrops() {
        Item[] drops;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int flowerAmount = random.nextInt(3);
        if (flowerAmount > 0) {
            drops = new Item[2];
            drops[1] = Item.getBlock(38, 0, flowerAmount);
        } else {
            drops = new Item[]{Item.get(265, 0, random.nextInt(3, 6))};
        }
        return drops;
    }
}

