/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAnvil;
import cn.nukkit.blockproperty.value.AnvilDamage;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.block.BlockEvent;
import cn.nukkit.inventory.transaction.CraftingTransaction;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Since(value="1.1.1.0-PN")
public class AnvilDamageEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    @Nullable
    private final Player player;
    @Nullable
    private final CraftingTransaction transaction;
    @Nonnull
    private final DamageCause cause;
    @Nonnull
    private final BlockState oldState;
    @Nonnull
    private BlockState newState;

    @Since(value="1.1.1.0-PN")
    public static HandlerList getHandlers() {
        return handlers;
    }

    @Since(value="1.4.0.0-PN")
    public AnvilDamageEvent(@Nonnull Block block, int oldDamage, int newDamage, @Nonnull DamageCause cause, @Nullable Player player) {
        this(AnvilDamageEvent.adjustBlock(block, oldDamage), block.getCurrentState().withData(newDamage), player, null, cause);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public AnvilDamageEvent(@Nonnull Block block, @Nonnull Block newState, @Nullable Player player, @Nullable CraftingTransaction transaction, @Nonnull DamageCause cause) {
        this(block, newState.getCurrentState(), player, transaction, cause);
    }

    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public AnvilDamageEvent(@Nonnull Block block, @Nonnull BlockState newState, @Nullable Player player, @Nullable CraftingTransaction transaction, @Nonnull DamageCause cause) {
        super(((Block)Preconditions.checkNotNull((Object)block, (Object)"block")).clone());
        this.oldState = block.getCurrentState();
        this.player = player;
        this.transaction = transaction;
        this.cause = (DamageCause)((Object)Preconditions.checkNotNull((Object)((Object)cause), (Object)"cause"));
        this.newState = (BlockState)Preconditions.checkNotNull((Object)newState, (Object)"newState");
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.1.1.0-PN")
    public CraftingTransaction getTransaction() {
        return this.transaction;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public DamageCause getDamageCause() {
        return this.cause;
    }

    @Deprecated
    @DeprecationDetails(since="1.6.0.0-PN", by="PowerNukkit", reason="Unstable use of raw block state data", replaceWith="getOldAnvilDamage or getOldBlockState")
    @Since(value="1.4.0.0-PN")
    public int getOldDamage() {
        if (!this.block.getProperties().contains(BlockAnvil.DAMAGE)) {
            return 0;
        }
        return this.block.getIntValue(BlockAnvil.DAMAGE);
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public AnvilDamage getOldAnvilDamage() {
        if (this.oldState.getProperties().contains(BlockAnvil.DAMAGE)) {
            return this.oldState.getPropertyValue(BlockAnvil.DAMAGE);
        }
        return null;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public BlockState getOldBlockState() {
        return this.oldState;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public BlockState getNewBlockState() {
        return this.newState;
    }

    @Nonnull
    @PowerNukkitOnly(value="Used to be inherited from BlockFadeEvent")
    @Since(value="1.1.1.0-PN")
    public Block getNewState() {
        return this.newState.getBlockRepairing(this.block);
    }

    @Deprecated
    @DeprecationDetails(since="1.6.0.0-PN", by="PowerNukkit", reason="Unstable use of raw block state data", replaceWith="getNewAnvilDamage or getNewBlockState")
    @Since(value="1.4.0.0-PN")
    public int getNewDamage() {
        BlockState newBlockState = this.getNewBlockState();
        return newBlockState.getProperties().contains(BlockAnvil.DAMAGE) ? newBlockState.getIntValue(BlockAnvil.DAMAGE) : 0;
    }

    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public void setNewBlockState(@Nonnull BlockState state) {
        this.newState = (BlockState)Preconditions.checkNotNull((Object)state);
    }

    @Deprecated
    @DeprecationDetails(since="1.6.0.0-PN", by="PowerNukkit", reason="Unstable use of raw block state data", replaceWith="setNewBlockState example: setNewBlockState(BlockState.of(BlockID.ANVIL).withProperty(BlockAnvil.DAMAGE, AnvilDamage.VERY_DAMAGED))")
    @Since(value="1.4.0.0-PN")
    public void setNewDamage(int newDamage) {
        BlockState newBlockState = this.getNewBlockState();
        if (newBlockState.getProperties().contains(BlockAnvil.DAMAGE)) {
            this.setNewBlockState(newBlockState.withProperty(BlockAnvil.DAMAGE, BlockAnvil.DAMAGE.getValueForMeta(newDamage)));
        }
    }

    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public void setNewState(@Nonnull Block block) {
        this.newState = block.getCurrentState();
    }

    @Nonnull
    @Since(value="1.6.0.0-PN")
    public DamageCause getCause() {
        return this.cause;
    }

    @Nullable
    @Since(value="1.1.1.0-PN")
    public Player getPlayer() {
        return this.player;
    }

    private static Block adjustBlock(Block block, int damage) {
        Block adjusted = ((Block)Preconditions.checkNotNull((Object)block, (Object)"block")).clone();
        adjusted.setDataStorage(damage);
        return adjusted;
    }

    @Since(value="1.4.0.0-PN")
    public static enum DamageCause {
        USE,
        FALL;

    }
}

