/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.blockentity.BlockEntityLectern;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.block.BlockEvent;

@PowerNukkitOnly
public class LecternPageChangeEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private final BlockEntityLectern lectern;
    private int newRawPage;

    @PowerNukkitOnly
    public LecternPageChangeEvent(Player player, BlockEntityLectern lectern, int newPage) {
        super(lectern.getBlock());
        this.player = player;
        this.lectern = lectern;
        this.newRawPage = newPage;
    }

    @PowerNukkitOnly
    public static HandlerList getHandlers() {
        return handlers;
    }

    @PowerNukkitOnly
    public BlockEntityLectern getLectern() {
        return this.lectern;
    }

    @PowerNukkitOnly
    public int getLeftPage() {
        return this.newRawPage * 2 + 1;
    }

    @PowerNukkitOnly
    public int getRightPage() {
        return this.getLeftPage() + 1;
    }

    @PowerNukkitOnly
    public void setLeftPage(int newLeftPage) {
        this.newRawPage = (newLeftPage - 1) / 2;
    }

    @PowerNukkitOnly
    public void setRightPage(int newRightPage) {
        this.setLeftPage(newRightPage - 1);
    }

    @PowerNukkitOnly
    public int getNewRawPage() {
        return this.newRawPage;
    }

    @PowerNukkitOnly
    public void setNewRawPage(int newRawPage) {
        this.newRawPage = newRawPage;
    }

    @PowerNukkitOnly
    public int getMaxPage() {
        return this.lectern.getTotalPages();
    }

    @PowerNukkitOnly
    public Player getPlayer() {
        return this.player;
    }
}

