/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.entity;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.Event;
import cn.nukkit.event.HandlerList;
import cn.nukkit.level.Position;
import cn.nukkit.nbt.tag.CompoundTag;

public class CreatureSpawnEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final SpawnReason reason;
    private final int entityNetworkId;
    private final Position position;
    private final CompoundTag compoundTag;

    public static HandlerList getHandlers() {
        return handlers;
    }

    public CreatureSpawnEvent(int networkId, Position position, CompoundTag nbt, SpawnReason reason) {
        this.reason = reason;
        this.entityNetworkId = networkId;
        this.position = position;
        this.compoundTag = nbt;
    }

    @PowerNukkitOnly
    public CreatureSpawnEvent(int networkId, Position position, SpawnReason reason) {
        this.reason = reason;
        this.entityNetworkId = networkId;
        this.position = position;
        this.compoundTag = Entity.getDefaultNBT(position);
    }

    public SpawnReason getReason() {
        return this.reason;
    }

    public int getEntityNetworkId() {
        return this.entityNetworkId;
    }

    public CompoundTag getCompoundTag() {
        return this.compoundTag;
    }

    public Position getPosition() {
        return this.position;
    }

    public static enum SpawnReason {
        NATURAL,
        JOCKEY,
        SPAWNER,
        EGG,
        SPAWN_EGG,
        LIGHTNING,
        BUILD_SNOWMAN,
        BUILD_IRONGOLEM,
        BUILD_WITHER,
        VILLAGE_DEFENSE,
        VILLAGE_INVASION,
        BREEDING,
        SLIME_SPLIT,
        REINFORCEMENTS,
        NETHER_PORTAL,
        DISPENSE_EGG,
        INFECTION,
        CURED,
        OCELOT_BABY,
        SILVERFISH_BLOCK,
        MOUNT,
        TRAP,
        ENDER_PEARL,
        SHOULDER_ENTITY,
        DROWNED,
        SHEARED,
        CUSTOM,
        DEFAULT,
        TURTLE_EGG;

    }
}

