/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBarrel;
import cn.nukkit.blockentity.BlockEntityBarrel;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.level.Level;
import cn.nukkit.level.Sound;
import cn.nukkit.math.Vector3;

@PowerNukkitOnly
public class BarrelInventory
extends ContainerInventory {
    @PowerNukkitOnly
    public BarrelInventory(BlockEntityBarrel barrel) {
        super(barrel, InventoryType.BARREL);
    }

    @Override
    public BlockEntityBarrel getHolder() {
        return (BlockEntityBarrel)this.holder;
    }

    @Override
    public void onOpen(Player who) {
        BlockBarrel blockBarrel;
        Block block;
        BlockEntityBarrel barrel;
        Level level;
        super.onOpen(who);
        if (this.getViewers().size() == 1 && (level = (barrel = this.getHolder()).getLevel()) != null && (block = barrel.getBlock()) instanceof BlockBarrel && !(blockBarrel = (BlockBarrel)block).isOpen()) {
            blockBarrel.setOpen(true);
            level.setBlock((Vector3)blockBarrel, blockBarrel, true, true);
            level.addSound(blockBarrel, Sound.BLOCK_BARREL_OPEN);
        }
    }

    @Override
    public void onClose(Player who) {
        BlockBarrel blockBarrel;
        Block block;
        BlockEntityBarrel barrel;
        Level level;
        super.onClose(who);
        if (this.getViewers().isEmpty() && (level = (barrel = this.getHolder()).getLevel()) != null && (block = barrel.getBlock()) instanceof BlockBarrel && (blockBarrel = (BlockBarrel)block).isOpen()) {
            blockBarrel.setOpen(false);
            level.setBlock((Vector3)blockBarrel, blockBarrel, true, true);
            level.addSound(blockBarrel, Sound.BLOCK_BARREL_CLOSE);
        }
    }
}

