/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.item.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@PowerNukkitOnly
public class RepairRecipe
implements Recipe {
    private final Item result;
    private final List<Item> ingredients;
    private final InventoryType inventoryType;

    @PowerNukkitOnly
    public RepairRecipe(InventoryType inventoryType, Item result, Collection<Item> ingredients) {
        this.inventoryType = inventoryType;
        this.result = result.clone();
        this.ingredients = new ArrayList<Item>();
        for (Item item : ingredients) {
            if (item.getCount() < 1) {
                throw new IllegalArgumentException("Recipe Ingredient amount was not 1 (value: " + item.getCount() + ")");
            }
            this.ingredients.add(item.clone());
        }
    }

    @Override
    public Item getResult() {
        return this.result.clone();
    }

    @PowerNukkitOnly
    public List<Item> getIngredientList() {
        ArrayList<Item> ingredients = new ArrayList<Item>();
        for (Item ingredient : this.ingredients) {
            ingredients.add(ingredient.clone());
        }
        return ingredients;
    }

    @Override
    public void registerToCraftingManager(CraftingManager manager) {
    }

    @Override
    public RecipeType getType() {
        return RecipeType.REPAIR;
    }

    @PowerNukkitOnly
    public InventoryType getInventoryType() {
        return this.inventoryType;
    }
}

