/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction.action;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.item.Item;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class GrindstoneItemAction
extends InventoryAction {
    private final int type;
    private final int experience;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public GrindstoneItemAction(Item sourceItem, Item targetItem, int type, int experience) {
        super(sourceItem, targetItem);
        this.type = type;
        this.experience = experience;
    }

    @Override
    public boolean isValid(Player source) {
        return source.getWindowById(Player.GRINDSTONE_WINDOW_ID) != null;
    }

    @Override
    public boolean execute(Player source) {
        int exp = this.getExperience();
        if (exp > 0) {
            source.getLevel().dropExpOrb(source, exp, null, 3);
        }
        return true;
    }

    @Override
    public void onExecuteSuccess(Player source) {
    }

    @Override
    public void onExecuteFail(Player source) {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getExperience() {
        return this.experience;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getType() {
        return this.type;
    }
}

