/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction.action;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.item.Item;
import lombok.Generated;

@PowerNukkitOnly
public class TakeLevelAction
extends InventoryAction {
    private final int levels;

    @PowerNukkitOnly
    public TakeLevelAction(int levels) {
        super(Item.get(0), Item.get(0));
        this.levels = levels;
    }

    @PowerNukkitOnly
    public int getLevels() {
        return this.levels;
    }

    @Override
    public boolean isValid(Player source) {
        return source.isCreative() || source.getExperienceLevel() >= this.levels;
    }

    @Override
    public boolean execute(Player source) {
        if (source.isCreative()) {
            return true;
        }
        int playerLevels = source.getExperienceLevel();
        if (playerLevels < this.levels) {
            return false;
        }
        source.setExperience(source.getExperience(), playerLevels - this.levels, false);
        return true;
    }

    @Override
    public void onExecuteSuccess(Player source) {
    }

    @Override
    public void onExecuteFail(Player source) {
    }

    @Override
    @Generated
    public String toString() {
        return "TakeLevelAction(super=" + super.toString() + ", levels=" + this.getLevels() + ")";
    }
}

