/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityArmorStand;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.CompassRoseDirection;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;

@Since(value="1.4.0.0-PN")
public class ItemArmorStand
extends Item {
    @Since(value="1.4.0.0-PN")
    public ItemArmorStand() {
        this((Integer)0);
    }

    @Since(value="1.4.0.0-PN")
    public ItemArmorStand(Integer meta) {
        this(meta, 1);
    }

    @Since(value="1.4.0.0-PN")
    public ItemArmorStand(Integer meta, int count) {
        super(425, meta, count, "Armor Stand");
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (player.isAdventure()) {
            return false;
        }
        FullChunk chunk = block.getChunk();
        if (chunk == null) {
            return false;
        }
        if (!block.canBeReplaced() || !block.up().canBeReplaced()) {
            return false;
        }
        for (Entity collidingEntity : level.getCollidingEntities(new SimpleAxisAlignedBB(block.x, block.y, block.z, block.x + 1.0, block.y + 1.0, block.z + 1.0))) {
            if (!(collidingEntity instanceof EntityArmorStand)) continue;
            return false;
        }
        CompassRoseDirection direction = CompassRoseDirection.getClosestFromYaw(player.yaw, CompassRoseDirection.Precision.PRIMARY_INTER_CARDINAL).getOppositeFace();
        CompoundTag nbt = Entity.getDefaultNBT(block.add(0.5, 0.0, 0.5), new Vector3(), direction.getYaw(), 0.0f);
        if (this.hasCustomName()) {
            nbt.putString("CustomName", this.getCustomName());
        }
        if (!this.removeForPlacement(block) || !this.removeForPlacement(block.up())) {
            return false;
        }
        Entity entity = Entity.createEntity(61, chunk, nbt, new Object[0]);
        if (entity == null) {
            return false;
        }
        if (!player.isCreative()) {
            player.getInventory().decreaseCount(player.getInventory().getHeldItemIndex());
        }
        entity.spawnToAll();
        player.getLevel().addSound(entity, Sound.MOB_ARMOR_STAND_PLACE);
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean removeForPlacement(Block block) {
        switch (block.getId()) {
            case 0: {
                return true;
            }
            case 78: {
                return block.canBeReplaced();
            }
        }
        return block.getLevel().setBlock(block, Block.get(0));
    }
}

