/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockUnknown;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.item.Item;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemBlock
extends Item {
    @Generated
    private static final Logger log = LogManager.getLogger(ItemBlock.class);

    public ItemBlock(Block block) {
        this(block, (Integer)0, 1);
    }

    public ItemBlock(Block block, Integer meta) {
        this(block, meta, 1);
    }

    public ItemBlock(Block block, Integer meta, int count) {
        super(block.getItemId(), meta, count, block.getName());
        this.block = block;
    }

    @Override
    public void setDamage(Integer meta) {
        int blockMeta;
        if (meta != null) {
            this.meta = meta;
            blockMeta = meta;
        } else {
            this.hasMeta = false;
            blockMeta = 0;
        }
        int blockId = this.block.getId();
        try {
            if (this.block instanceof BlockUnknown) {
                this.block = BlockState.of(blockId, blockMeta).getBlock();
                log.info("An invalid ItemBlock for {} was set to a valid meta {} and it is now safe again", (Object)this.block.getPersistenceName(), (Object)meta);
            } else {
                this.block.setDataStorageFromItemBlockMeta(blockMeta);
                this.name = this.block.getName();
            }
        }
        catch (InvalidBlockStateException e) {
            log.warn("An ItemBlock for {} was set to have meta {} but this value is not valid. The item stack is now unsafe.", (Object)this.block.getPersistenceName(), (Object)meta, (Object)e);
            this.block = new BlockUnknown(blockId, (Integer)blockMeta);
            this.name = this.block.getName();
            return;
        }
        int expected = this.block.asItemBlock().getDamage();
        if (expected != blockMeta) {
            log.warn("An invalid ItemBlock for {} was set to an valid meta {} for item blocks, it was expected to have meta {} the stack is now unsafe.\nProperties: {}", (Object)this.block.getPersistenceName(), (Object)meta, (Object)expected, (Object)this.block.getProperties());
        }
    }

    @Override
    public ItemBlock clone() {
        ItemBlock block = (ItemBlock)super.clone();
        block.block = this.block.clone();
        return block;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    @PowerNukkitOnly
    public boolean isLavaResistant() {
        return this.block.isLavaResistant();
    }
}

