/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.item.ItemPotion;
import cn.nukkit.item.ProjectileItem;
import cn.nukkit.nbt.tag.CompoundTag;

public class ItemPotionLingering
extends ProjectileItem {
    public ItemPotionLingering() {
        this((Integer)0, 1);
    }

    public ItemPotionLingering(Integer meta) {
        this(meta, 1);
    }

    public ItemPotionLingering(Integer meta, int count) {
        super(441, meta, count, "Lingering Potion");
        this.updateName();
    }

    @Override
    public void setDamage(Integer meta) {
        super.setDamage(meta);
        this.updateName();
    }

    private void updateName() {
        int potionId = this.getDamage();
        this.name = potionId == 0 ? "Lingering Water Bottle" : ItemPotion.buildName(potionId, "Lingering Potion", true);
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public String getProjectileEntityType() {
        return "LingeringPotion";
    }

    @Override
    @PowerNukkitOnly
    public float getThrowForce() {
        return 0.5f;
    }

    @Override
    @PowerNukkitOnly
    protected void correctNBT(CompoundTag nbt) {
        nbt.putInt("PotionId", this.meta);
    }
}

