/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.enchantment.damage;

import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityArthropod;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.item.enchantment.damage.EnchantmentDamage;
import cn.nukkit.potion.Effect;
import java.util.concurrent.ThreadLocalRandom;

public class EnchantmentDamageArthropods
extends EnchantmentDamage {
    public EnchantmentDamageArthropods() {
        super(11, "arthropods", Enchantment.Rarity.UNCOMMON, EnchantmentDamage.TYPE.SMITE);
    }

    @Override
    public int getMinEnchantAbility(int level) {
        return 5 + (level - 1) * 8;
    }

    @Override
    public int getMaxEnchantAbility(int level) {
        return this.getMinEnchantAbility(level) + 20;
    }

    @Override
    public double getDamageBonus(Entity entity) {
        if (entity instanceof EntityArthropod) {
            return (double)this.getLevel() * 2.5;
        }
        return 0.0;
    }

    @Override
    public void doPostAttack(Entity attacker, Entity entity) {
        if (entity instanceof EntityArthropod) {
            int duration = 20 + ThreadLocalRandom.current().nextInt(10 * this.level);
            entity.addEffect(Effect.getEffect(2).setDuration(duration).setAmplifier(3));
        }
    }
}

