/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.LevelException;
import javax.annotation.Nonnull;

public class Location
extends Position {
    public double yaw;
    public double pitch;
    @Since(value="1.6.0.0-PN")
    public double headYaw;

    public Location() {
        this(0.0);
    }

    public Location(double x) {
        this(x, 0.0);
    }

    public Location(double x, double y) {
        this(x, y, 0.0);
    }

    public Location(double x, double y, double z) {
        this(x, y, z, 0.0);
    }

    public Location(double x, double y, double z, Level level) {
        this(x, y, z, 0.0, 0.0, level);
    }

    public Location(double x, double y, double z, double yaw) {
        this(x, y, z, yaw, 0.0);
    }

    public Location(double x, double y, double z, double yaw, double pitch) {
        this(x, y, z, yaw, pitch, null);
    }

    public Location(double x, double y, double z, double yaw, double pitch, Level level) {
        this(x, y, z, yaw, pitch, 0.0, level);
    }

    @Since(value="1.6.0.0-PN")
    public Location(double x, double y, double z, double yaw, double pitch, double headYaw) {
        this(x, y, z, yaw, pitch, headYaw, null);
    }

    @Since(value="1.6.0.0-PN")
    public Location(double x, double y, double z, double yaw, double pitch, double headYaw, Level level) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.headYaw = headYaw;
        this.level = level;
    }

    public static Location fromObject(Vector3 pos) {
        return Location.fromObject(pos, null, 0.0, 0.0);
    }

    public static Location fromObject(Vector3 pos, Level level) {
        return Location.fromObject(pos, level, 0.0, 0.0);
    }

    public static Location fromObject(Vector3 pos, Level level, double yaw) {
        return Location.fromObject(pos, level, yaw, 0.0);
    }

    public static Location fromObject(Vector3 pos, Level level, double yaw, double pitch) {
        return new Location(pos.x, pos.y, pos.z, yaw, pitch, level == null ? (pos instanceof Position ? ((Position)pos).level : null) : level);
    }

    @Since(value="1.6.0.0-PN")
    public static Location fromObject(Vector3 pos, Level level, double yaw, double pitch, double headYaw) {
        if (level == null && pos instanceof Position) {
            level = ((Position)pos).level;
        }
        return new Location(pos.x, pos.y, pos.z, yaw, pitch, headYaw, level);
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getPitch() {
        return this.pitch;
    }

    @Since(value="1.6.0.0-PN")
    public double getHeadYaw() {
        return this.headYaw;
    }

    @PowerNukkitOnly
    public Location setYaw(double yaw) {
        this.yaw = yaw;
        return this;
    }

    @PowerNukkitOnly
    public Location setPitch(double pitch) {
        this.pitch = pitch;
        return this;
    }

    @Override
    public String toString() {
        return "Location (level=" + (this.isValid() ? this.getLevel().getName() : "null") + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ", headYaw=" + this.headYaw + ")";
    }

    @Override
    @Nonnull
    public Location getLocation() {
        if (this.isValid()) {
            return new Location(this.x, this.y, this.z, this.yaw, this.pitch, this.headYaw, this.level);
        }
        throw new LevelException("Undefined Level reference");
    }

    @Override
    public Location add(double x) {
        return this.add(x, 0.0, 0.0);
    }

    @Override
    public Location add(double x, double y) {
        return this.add(x, y, 0.0);
    }

    @Override
    public Location add(double x, double y, double z) {
        return new Location(this.x + x, this.y + y, this.z + z, this.yaw, this.pitch, this.headYaw, this.level);
    }

    @Override
    public Location add(Vector3 x) {
        return new Location(this.x + x.getX(), this.y + x.getY(), this.z + x.getZ(), this.yaw, this.pitch, this.headYaw, this.level);
    }

    @Override
    public Location subtract() {
        return this.subtract(0.0, 0.0, 0.0);
    }

    @Override
    public Location subtract(double x) {
        return this.subtract(x, 0.0, 0.0);
    }

    @Override
    public Location subtract(double x, double y) {
        return this.subtract(x, y, 0.0);
    }

    @Override
    public Location subtract(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    @Override
    public Location subtract(Vector3 x) {
        return this.add(-x.getX(), -x.getY(), -x.getZ());
    }

    @Override
    public Location multiply(double number) {
        return new Location(this.x * number, this.y * number, this.z * number, this.yaw, this.pitch, this.headYaw, this.level);
    }

    @Override
    public Location divide(double number) {
        return new Location(this.x / number, this.y / number, this.z / number, this.yaw, this.pitch, this.headYaw, this.level);
    }

    @Override
    public Location ceil() {
        return new Location((int)Math.ceil(this.x), (int)Math.ceil(this.y), (int)Math.ceil(this.z), this.yaw, this.pitch, this.headYaw, this.level);
    }

    @Override
    public Location floor() {
        return new Location(this.getFloorX(), this.getFloorY(), this.getFloorZ(), this.yaw, this.pitch, this.headYaw, this.level);
    }

    @Override
    public Location round() {
        return new Location(Math.round(this.x), Math.round(this.y), Math.round(this.z), this.yaw, this.pitch, this.headYaw, this.level);
    }

    @Override
    public Location abs() {
        return new Location((int)Math.abs(this.x), (int)Math.abs(this.y), (int)Math.abs(this.z), this.yaw, this.pitch, this.headYaw, this.level);
    }

    public Vector3 getDirectionVector() {
        double pitch = (this.getPitch() + 90.0) * Math.PI / 180.0;
        double yaw = (this.getYaw() + 90.0) * Math.PI / 180.0;
        double x = Math.sin(pitch) * Math.cos(yaw);
        double z = Math.sin(pitch) * Math.sin(yaw);
        double y = Math.cos(pitch);
        return new Vector3(x, y, z).normalize();
    }

    @Override
    public Location clone() {
        return (Location)super.clone();
    }
}

