/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.impl.iceplains;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.biome.impl.iceplains.IcePlainsBiome;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;

public class IcePlainsSpikesBiome
extends IcePlainsBiome {
    public IcePlainsSpikesBiome() {
        PopulatorIceSpikes iceSpikes = new PopulatorIceSpikes();
        this.addPopulator(iceSpikes);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getSurfaceBlock(int y) {
        if (this.useNewRakNetSurface()) {
            return this.getSurfaceId(0, y, 0) >> 4;
        }
        return 80;
    }

    @Override
    public String getName() {
        return "Ice Plains Spikes";
    }

    @Override
    public boolean isFreezing() {
        return true;
    }

    private static class PopulatorIceSpikes
    extends Populator {
        private PopulatorIceSpikes() {
        }

        @Override
        public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
            for (int i = 0; i < 8; ++i) {
                int x = (chunkX << 4) + random.nextBoundedInt(16);
                int z = (chunkZ << 4) + random.nextBoundedInt(16);
                boolean isTall = random.nextBoundedInt(16) == 0;
                int height = 10 + random.nextBoundedInt(16) + (isTall ? random.nextBoundedInt(31) : 0);
                int startY = this.getHighestWorkableBlock(x, z, chunk);
                int maxY = startY + height;
                if (isTall) {
                    int y;
                    for (y = startY; y < maxY; ++y) {
                        level.setBlockAt(x, y, z, 174);
                        level.setBlockAt(x + 1, y, z, 174);
                        level.setBlockAt(x - 1, y, z, 174);
                        level.setBlockAt(x, y, z + 1, 174);
                        level.setBlockAt(x, y, z - 1, 174);
                        if (random.nextBoolean()) {
                            level.setBlockAt(x + 1, y, z + 1, 174);
                        }
                        if (random.nextBoolean()) {
                            level.setBlockAt(x + 1, y, z - 1, 174);
                        }
                        if (random.nextBoolean()) {
                            level.setBlockAt(x - 1, y, z + 1, 174);
                        }
                        if (!random.nextBoolean()) continue;
                        level.setBlockAt(x - 1, y, z - 1, 174);
                    }
                    level.setBlockAt(x + 1, maxY, z, 174);
                    level.setBlockAt(x - 1, maxY, z, 174);
                    level.setBlockAt(x, maxY, z + 1, 174);
                    level.setBlockAt(x, maxY, z - 1, 174);
                    for (y = maxY; y < maxY + 3; ++y) {
                        level.setBlockAt(x, y, z, 174);
                    }
                    continue;
                }
                int baseWidth = random.nextBoundedInt(1) + 4;
                float shrinkFactor = (float)baseWidth / (float)height;
                float currWidth = baseWidth;
                for (int y = startY; y < maxY; ++y) {
                    int xx = (int)(-currWidth);
                    while ((float)xx < currWidth) {
                        int zz = (int)(-currWidth);
                        while ((float)zz < currWidth) {
                            int currDist = (int)Math.sqrt(xx * xx + zz * zz);
                            if ((int)currWidth != currDist && random.nextBoolean()) {
                                level.setBlockAt(x + xx, y, z + zz, 174);
                            }
                            ++zz;
                        }
                        ++xx;
                    }
                    currWidth -= shrinkFactor;
                }
            }
        }

        public int getHighestWorkableBlock(int x, int z, FullChunk chunk) {
            return chunk.getHighestBlockAt(x & 0xF, z & 0xF) - 5;
        }
    }
}

