/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.type;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.biome.type.CoveredBiome;
import cn.nukkit.level.generator.populator.impl.PopulatorDoublePlant;
import cn.nukkit.level.generator.populator.impl.PopulatorGrass;

public abstract class GrassyBiome
extends CoveredBiome {
    public GrassyBiome() {
        PopulatorGrass grass = new PopulatorGrass();
        grass.setBaseAmount(30);
        this.addPopulator(grass);
        PopulatorDoublePlant tallGrass = new PopulatorDoublePlant(2);
        tallGrass.setBaseAmount(5);
        this.addPopulator(tallGrass);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getSurfaceBlock(int y) {
        if (this.useNewRakNetSurface()) {
            return this.getSurfaceId(0, y, 0);
        }
        return 2;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getGroundBlock(int y) {
        if (this.useNewRakNetGround()) {
            return this.getGroundId(0, y, 0) >> 4;
        }
        return 3;
    }
}

