/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockUnknown;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.anvil.LayerStorage;
import cn.nukkit.level.format.anvil.MultiLayerStorage;
import cn.nukkit.level.format.anvil.SingleLayerStorage;
import cn.nukkit.level.format.anvil.util.BlockStorage;
import cn.nukkit.level.format.anvil.util.ImmutableBlockStorage;
import cn.nukkit.level.format.anvil.util.NibbleArray;
import cn.nukkit.level.format.generic.EmptyChunkSection;
import cn.nukkit.level.format.updater.ChunkUpdater;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.nbt.tag.ByteArrayTag;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.ChunkException;
import cn.nukkit.utils.ThreadCache;
import cn.nukkit.utils.Utils;
import cn.nukkit.utils.Zlib;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class ChunkSection
implements cn.nukkit.level.format.ChunkSection {
    @Generated
    private static final Logger log = LogManager.getLogger(ChunkSection.class);
    @PowerNukkitOnly
    public static final int STREAM_STORAGE_VERSION = 8;
    @PowerNukkitOnly
    public static final int SAVE_STORAGE_VERSION = 7;
    private static final String STORAGE_TAG_NAME = "Storage";
    private static final String HUGE_TAG_NAME = "DataHyper";
    private static final BigInteger BYTE_MASK = BigInteger.valueOf(255L);
    private final int y;
    private LayerStorage layerStorage;
    protected byte[] blockLight;
    protected byte[] skyLight;
    protected byte[] compressedLight;
    protected boolean hasBlockLight;
    protected boolean hasSkyLight;
    private int contentVersion;

    private ChunkSection(int y, LayerStorage layerStorage, @Nullable byte[] blockLight, @Nullable byte[] skyLight, @Nullable byte[] compressedLight, boolean hasBlockLight, boolean hasSkyLight) {
        this.y = y;
        this.layerStorage = layerStorage;
        this.skyLight = skyLight;
        this.blockLight = blockLight;
        this.compressedLight = compressedLight;
        this.hasBlockLight = hasBlockLight;
        this.hasSkyLight = hasSkyLight;
    }

    public ChunkSection(int y) {
        this.y = y;
        this.contentVersion = ChunkUpdater.getCurrentContentVersion();
        this.layerStorage = LayerStorage.EMPTY;
        this.hasBlockLight = false;
        this.hasSkyLight = false;
    }

    public ChunkSection(CompoundTag nbt) {
        this.y = nbt.getByte("Y");
        this.setContentVersion(nbt.getByte("ContentVersion"));
        int version = nbt.getByte("Version");
        ListTag<CompoundTag> storageTagList = ChunkSection.getStorageTagList(nbt, version);
        switch (storageTagList.size()) {
            case 0: {
                this.layerStorage = LayerStorage.EMPTY;
                break;
            }
            case 1: {
                this.layerStorage = new SingleLayerStorage();
                break;
            }
            default: {
                this.layerStorage = new MultiLayerStorage(ImmutableBlockStorage.EMPTY, ImmutableBlockStorage.EMPTY);
            }
        }
        for (int i = 0; i < storageTagList.size(); ++i) {
            CompoundTag storageTag = storageTagList.get(i);
            this.loadStorage(i, storageTag);
        }
        this.layerStorage.compress(this::setLayerStorage);
        this.blockLight = nbt.getByteArray("BlockLight");
        this.skyLight = nbt.getByteArray("SkyLight");
    }

    private void loadStorage(int layer, CompoundTag storageTag) {
        NibbleArray data;
        byte[] dataBytes;
        byte[] blocks = storageTag.getByteArray("Blocks");
        boolean hasBlockIds = false;
        if (blocks.length == 0) {
            blocks = EmptyChunkSection.EMPTY_ID_ARRAY;
        } else {
            hasBlockIds = true;
        }
        byte[] blocksExtra = storageTag.getByteArray("BlocksExtra");
        if (blocksExtra.length == 0) {
            blocksExtra = EmptyChunkSection.EMPTY_ID_ARRAY;
        }
        if ((dataBytes = storageTag.getByteArray("Data")).length == 0) {
            data = NibbleArray.EMPTY_DATA_ARRAY;
        } else {
            hasBlockIds = true;
            data = new NibbleArray(dataBytes);
        }
        byte[] dataExtraBytes = storageTag.getByteArray("DataExtra");
        if (dataExtraBytes.length == 0) {
            dataExtraBytes = EmptyChunkSection.EMPTY_DATA_ARRAY;
        }
        NibbleArray dataExtra = new NibbleArray(dataExtraBytes);
        ListTag<ByteArrayTag> hugeDataList = storageTag.getList(HUGE_TAG_NAME, ByteArrayTag.class);
        int hugeDataSize = hugeDataList.size();
        if (!hasBlockIds && hugeDataSize == 0) {
            return;
        }
        if (this.getContentVersion() > ChunkUpdater.getCurrentContentVersion()) {
            log.warn("Loading a chunk section with content version ({}) higher than the current version ({}), Errors may occur and the chunk may get corrupted blocks!", (Object)this.getContentVersion(), (Object)ChunkUpdater.getCurrentContentVersion());
        }
        BlockStorage storage = this.layerStorage.getOrSetStorage(this::setLayerStorage, this::getContentVersion, layer);
        for (int bx = 0; bx < 16; ++bx) {
            for (int bz = 0; bz < 16; ++bz) {
                for (int by = 0; by < 16; ++by) {
                    int index = ChunkSection.getAnvilIndex(bx, by, bz);
                    int blockId = ChunkSection.composeBlockId(blocks[index], blocksExtra[index]);
                    int composedData = ChunkSection.composeData(data.get(index), dataExtra.get(index));
                    BlockState state = ChunkSection.loadState(index, blockId, composedData, hugeDataList, hugeDataSize);
                    storage.setBlockState(bx, by, bz, state);
                }
            }
        }
    }

    private static BlockState loadState(int index, int blockId, int composedData, ListTag<ByteArrayTag> hugeDataList, int hugeDataSize) {
        if (hugeDataSize == 0) {
            return BlockState.of(blockId, composedData);
        }
        if (hugeDataSize < 3) {
            return ChunkSection.loadHugeIntData(index, blockId, composedData, hugeDataList, hugeDataSize);
        }
        if (hugeDataSize < 7) {
            return ChunkSection.loadHugeLongData(index, blockId, composedData, hugeDataList, hugeDataSize);
        }
        return ChunkSection.loadHugeBigData(index, blockId, composedData, hugeDataList, hugeDataSize);
    }

    private static BlockState loadHugeIntData(int index, int blockId, int composedData, ListTag<ByteArrayTag> hugeDataList, int hugeDataSize) {
        int data = composedData;
        for (int dataIndex = 0; dataIndex < hugeDataSize; ++dataIndex) {
            int longPart = (hugeDataList.get((int)dataIndex).data[index] & 0xFF) << 8 << 8 * dataIndex;
            data |= longPart;
        }
        return BlockState.of(blockId, data);
    }

    private static BlockState loadHugeLongData(int index, int blockId, int composedData, ListTag<ByteArrayTag> hugeDataList, int hugeDataSize) {
        long data = composedData;
        for (int dataIndex = 0; dataIndex < hugeDataSize; ++dataIndex) {
            long longPart = ((long)hugeDataList.get((int)dataIndex).data[index] & 0xFFL) << 8 << 8 * dataIndex;
            data |= longPart;
        }
        return BlockState.of(blockId, data);
    }

    private static BlockState loadHugeBigData(int index, int blockId, int composedData, ListTag<ByteArrayTag> hugeDataList, int hugeDataSize) {
        BigInteger data = BigInteger.valueOf(composedData);
        for (int dataIndex = 0; dataIndex < hugeDataSize; ++dataIndex) {
            BigInteger hugePart = BigInteger.valueOf(((long)hugeDataList.get((int)dataIndex).data[index] & 0xFFL) << 8).shiftLeft(8 * dataIndex);
            data = data.or(hugePart);
        }
        return BlockState.of(blockId, data);
    }

    private static ListTag<CompoundTag> getStorageTagList(CompoundTag nbt, int version) {
        ListTag<CompoundTag> storageTagList;
        if (version == 7 || version == 8) {
            storageTagList = nbt.getList(STORAGE_TAG_NAME, CompoundTag.class);
        } else if (version == 0 || version == 1) {
            storageTagList = new ListTag(STORAGE_TAG_NAME);
            storageTagList.add(nbt);
        } else {
            throw new ChunkException("Unsupported chunk section version: " + version);
        }
        return storageTagList;
    }

    private static int composeBlockId(byte baseId, byte extraId) {
        return (extraId & 0xFF) << 8 | baseId & 0xFF;
    }

    private static int composeData(byte baseData, byte extraData) {
        return (extraData & 0xF) << 4 | baseData & 0xF;
    }

    private static int getAnvilIndex(int x, int y, int z) {
        return (y << 8) + (z << 4) + x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        return this.getBlockId(x, y, z, 0);
    }

    @Override
    @PowerNukkitOnly
    public int getBlockId(int x, int y, int z, int layer) {
        return this.layerStorage.getStorageOrEmpty(layer).getBlockId(x, y, z);
    }

    @Override
    public void setBlockId(int x, int y, int z, int id) {
        this.setBlockId(x, y, z, 0, id);
    }

    @Override
    @PowerNukkitOnly
    public synchronized void setBlockId(int x, int y, int z, int layer, int id) {
        if (id != 0) {
            this.layerStorage.getOrSetStorage(this::setLayerStorage, this::getContentVersion, layer).setBlockId(x, y, z, id);
        } else {
            BlockStorage storage = this.layerStorage.getStorageOrNull(layer);
            if (storage != null) {
                storage.setBlockId(x, y, z, id);
            }
        }
    }

    private void setLayerStorage(LayerStorage storage) {
        this.layerStorage = storage;
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public boolean setFullBlockId(int x, int y, int z, int fullId) {
        this.setFullBlockId(x, y, z, 0, fullId);
        return true;
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public synchronized boolean setFullBlockId(int x, int y, int z, int layer, int fullId) {
        if (fullId != 0) {
            this.layerStorage.getOrSetStorage(this::setLayerStorage, this::getContentVersion, layer).setFullBlock(x, y, z, fullId);
        } else {
            BlockStorage storage = this.layerStorage.getStorageOrNull(layer);
            if (storage != null) {
                storage.setFullBlock(x, y, z, fullId);
            }
        }
        return true;
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    public int getBlockData(int x, int y, int z) {
        return this.getBlockData(x, y, z, 0);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getBlockData(int x, int y, int z, int layer) {
        return this.layerStorage.getStorageOrEmpty(layer).getBlockData(x, y, z);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    public void setBlockData(int x, int y, int z, int data) {
        this.setBlockData(x, y, z, 0, data);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public synchronized void setBlockData(int x, int y, int z, int layer, int data) {
        if (data != 0) {
            this.layerStorage.getOrSetStorage(this::setLayerStorage, this::getContentVersion, layer).setBlockData(x, y, z, data);
        } else {
            BlockStorage storage = this.layerStorage.getStorageOrNull(layer);
            if (storage != null) {
                storage.setBlockData(x, y, z, data);
            }
        }
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(x, y, z, 0);
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public BlockState getBlockState(int x, int y, int z, int layer) {
        return this.layerStorage.getStorageOrEmpty(layer).getBlockState(x, y, z);
    }

    @Override
    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    public int getFullBlock(int x, int y, int z, int layer) {
        return this.layerStorage.getStorageOrEmpty(layer).getFullBlock(x, y, z);
    }

    @Override
    public boolean setBlock(int x, int y, int z, int blockId) {
        return this.setBlockStateAtLayer(x, y, z, 0, BlockState.of(blockId));
    }

    @Override
    @PowerNukkitOnly
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId) {
        return this.setBlockStateAtLayer(x, y, z, layer, BlockState.of(blockId));
    }

    @Override
    @Nonnull
    public Block getAndSetBlock(int x, int y, int z, Block block) {
        return this.getAndSetBlock(x, y, z, 0, block);
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public synchronized Block getAndSetBlock(int x, int y, int z, int layer, Block block) {
        BlockStorage storage;
        if (block.getId() != 0 || !block.isDefaultState()) {
            storage = this.layerStorage.getOrSetStorage(this::setLayerStorage, this::getContentVersion, layer);
        } else {
            storage = this.layerStorage.getStorageOrNull(layer);
            if (storage == null) {
                return BlockState.AIR.getBlock();
            }
        }
        BlockState state = storage.getAndSetBlockState(x, y, z, block.getCurrentState());
        try {
            return state.getBlock();
        }
        catch (InvalidBlockStateException ignored) {
            return new BlockUnknown(state.getBlockId(), (Integer)state.getExactIntStorage());
        }
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public synchronized BlockState getAndSetBlockState(int x, int y, int z, int layer, BlockState state) {
        if (!BlockState.AIR.equals(state)) {
            return this.layerStorage.getOrSetStorage(this::setLayerStorage, this::getContentVersion, layer).getAndSetBlockState(x, y, z, state);
        }
        BlockStorage storage = this.layerStorage.getStorageOrNull(layer);
        if (storage == null) {
            return BlockState.AIR;
        }
        return storage.getAndSetBlockState(x, y, z, state);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    public boolean setBlock(int x, int y, int z, int blockId, int meta) {
        return this.setBlockAtLayer(x, y, z, 0, blockId, meta);
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId, int meta) {
        return this.setBlockStateAtLayer(x, y, z, layer, BlockState.of(blockId, meta));
    }

    @Override
    @PowerNukkitOnly
    public synchronized boolean setBlockStateAtLayer(int x, int y, int z, int layer, BlockState state) {
        BlockState previous = this.getAndSetBlockState(x, y, z, layer, state);
        return !state.equals(previous);
    }

    @Override
    @PowerNukkitOnly
    public int getBlockChangeStateAbove(int x, int y, int z) {
        BlockStorage storage = this.layerStorage.getStorageOrNull(0);
        if (storage == null) {
            return 0;
        }
        return storage.getBlockChangeStateAbove(x, y, z);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public synchronized void delayPaletteUpdates() {
        this.layerStorage.delayPaletteUpdates();
    }

    @Override
    public int getBlockSkyLight(int x, int y, int z) {
        if (this.skyLight == null) {
            if (!this.hasSkyLight) {
                return 0;
            }
            if (this.compressedLight == null) {
                return 15;
            }
            this.skyLight = this.getSkyLightArray();
        }
        int sl = this.skyLight[y << 7 | z << 3 | x >> 1] & 0xFF;
        if ((x & 1) == 0) {
            return sl & 0xF;
        }
        return sl >> 4;
    }

    @Override
    public void setBlockSkyLight(int x, int y, int z, int level) {
        if (this.skyLight == null) {
            if (this.hasSkyLight && this.compressedLight != null) {
                this.skyLight = this.getSkyLightArray();
            } else {
                if (level == (this.hasSkyLight ? 15 : 0)) {
                    return;
                }
                this.skyLight = new byte[2048];
                if (this.hasSkyLight) {
                    Arrays.fill(this.skyLight, (byte)-1);
                }
            }
        }
        int i = y << 7 | z << 3 | x >> 1;
        int old = this.skyLight[i] & 0xFF;
        this.skyLight[i] = (x & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        if (this.blockLight == null && !this.hasBlockLight) {
            return 0;
        }
        this.blockLight = this.getLightArray();
        int l = this.blockLight[y << 7 | z << 3 | x >> 1] & 0xFF;
        if ((x & 1) == 0) {
            return l & 0xF;
        }
        return l >> 4;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int level) {
        if (this.blockLight == null) {
            if (this.hasBlockLight) {
                this.blockLight = this.getLightArray();
            } else {
                if (level == 0) {
                    return;
                }
                this.blockLight = new byte[2048];
            }
        }
        int i = y << 7 | z << 3 | x >> 1;
        int old = this.blockLight[i] & 0xFF;
        this.blockLight[i] = (x & 1) == 0 ? (byte)(old & 0xF0 | level & 0xF) : (byte)((level & 0xF) << 4 | old & 0xF);
    }

    @Override
    public byte[] getSkyLightArray() {
        if (this.skyLight != null) {
            return (byte[])this.skyLight.clone();
        }
        if (!this.hasSkyLight) {
            return new byte[EmptyChunkSection.EMPTY_LIGHT_ARR.length];
        }
        if (this.compressedLight != null && this.inflate() && this.skyLight != null) {
            return (byte[])this.skyLight.clone();
        }
        return (byte[])EmptyChunkSection.EMPTY_SKY_LIGHT_ARR.clone();
    }

    private boolean inflate() {
        try {
            if (this.compressedLight != null && this.compressedLight.length != 0) {
                byte[] inflated = Zlib.inflate(this.compressedLight);
                this.blockLight = Arrays.copyOfRange(inflated, 0, 2048);
                if (inflated.length > 2048) {
                    this.skyLight = Arrays.copyOfRange(inflated, 2048, 4096);
                } else {
                    this.skyLight = new byte[2048];
                    if (this.hasSkyLight) {
                        Arrays.fill(this.skyLight, (byte)-1);
                    }
                }
                this.compressedLight = null;
            } else {
                this.blockLight = new byte[2048];
                this.skyLight = new byte[2048];
                if (this.hasSkyLight) {
                    Arrays.fill(this.skyLight, (byte)-1);
                }
            }
            return true;
        }
        catch (IOException e) {
            log.error("Failed to decompress a chunk section", (Throwable)e);
            return false;
        }
    }

    @Override
    public byte[] getLightArray() {
        if (this.blockLight != null) {
            return (byte[])this.blockLight.clone();
        }
        if (this.hasBlockLight && this.compressedLight != null && this.inflate() && this.blockLight != null) {
            return (byte[])this.blockLight.clone();
        }
        return new byte[EmptyChunkSection.EMPTY_LIGHT_ARR.length];
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private byte[] toXZY(char[] raw) {
        int i;
        byte[] buffer = (byte[])ThreadCache.byteCache6144.get();
        for (i = 0; i < 4096; ++i) {
            buffer[i] = (byte)(raw[i] >> 4);
        }
        i = 0;
        int j = 4096;
        while (i < 4096) {
            buffer[j] = (byte)((raw[i + 1] & 0xF) << 4 | raw[i] & 0xF);
            i += 2;
            ++j;
        }
        return buffer;
    }

    @Override
    public synchronized void writeTo(@Nonnull BinaryStream stream) {
        this.layerStorage.writeTo(stream);
    }

    @Nullable
    private List<byte[]> saveData(BlockStorage storage, byte[] idsBase, @Nullable byte[] idsExtra, NibbleArray dataBase, @Nullable NibbleArray dataExtra) {
        ArrayList<byte[]> hugeList;
        boolean big;
        boolean huge = storage.hasBlockDataHuge();
        boolean bl = big = huge || storage.hasBlockDataBig();
        ArrayList<byte[]> arrayList = big ? new ArrayList<byte[]>(huge ? 3 : 1) : (hugeList = null);
        if (big) {
            hugeList.add(new byte[4096]);
        }
        storage.iterateStates((bx, by, bz, state) -> {
            int anvil = ChunkSection.getAnvilIndex(bx, by, bz);
            int blockId = state.getBlockId();
            if (blockId == 0) {
                return;
            }
            idsBase[anvil] = (byte)(blockId & 0xFF);
            if (idsExtra != null) {
                idsExtra[anvil] = (byte)(blockId >>> 8 & 0xFF);
            }
            int unsignedIntData = state.getBigDamage();
            dataBase.set(anvil, (byte)(unsignedIntData & 0xF));
            if (dataExtra != null) {
                dataExtra.set(anvil, (byte)(unsignedIntData >>> 4 & 0xF));
            }
            if (!big) {
                return;
            }
            ((byte[])hugeList.get((int)0))[anvil] = (byte)(unsignedIntData >>> 8 & 0xFF);
            if (huge) {
                this.saveHugeData((List<byte[]>)hugeList, (BlockState)state, anvil, unsignedIntData);
            }
        });
        return hugeList;
    }

    private void saveHugeData(List<byte[]> hugeList, BlockState state, int anvil, int intData) {
        int bitSize = state.getBitSize();
        if (bitSize <= 16) {
            return;
        }
        intData >>>= 16;
        int processedBits = 16;
        int pos = 1;
        while (processedBits < 32 && processedBits <= bitSize) {
            byte[] blob = this.allocateBlob(hugeList, pos);
            blob[anvil] = (byte)(intData & 0xFF);
            processedBits += 8;
            ++pos;
            intData >>>= 8;
        }
        if (processedBits >= bitSize) {
            return;
        }
        BigInteger hugeData = state.getHugeDamage().shiftRight(32);
        while (processedBits <= bitSize) {
            byte[] blob = this.allocateBlob(hugeList, pos);
            blob[anvil] = hugeData.and(BYTE_MASK).byteValue();
            processedBits += 8;
            ++pos;
            hugeData = hugeData.shiftRight(8);
        }
    }

    private byte[] allocateBlob(List<byte[]> hugeList, int pos) {
        byte[] blob;
        if (hugeList.size() <= pos) {
            blob = new byte[4096];
            hugeList.add(blob);
        } else {
            blob = hugeList.get(pos);
        }
        return blob;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public synchronized CompoundTag toNBT() {
        CompoundTag s = new CompoundTag();
        this.compressStorageLayers();
        s.putByte("Y", this.getY());
        int version = 7;
        ListTag<CompoundTag> storageList = new ListTag<CompoundTag>(STORAGE_TAG_NAME);
        int blockStorages = Math.max(1, this.layerStorage.size());
        for (int layer = 0; layer < blockStorages; ++layer) {
            CompoundTag storageTag;
            BlockStorage storage = this.layerStorage.getStorageOrEmpty(layer);
            if (layer == 0 && blockStorages == 1) {
                storageTag = s;
                version = !storage.hasBlockDataExtras() && !storage.hasBlockIdExtras() ? 0 : 1;
            } else {
                storageTag = new CompoundTag();
            }
            if (version == 0 || storage.hasBlockIds()) {
                byte[] idsBase = new byte[4096];
                byte[] idsExtra = storage.hasBlockIdExtras() ? new byte[4096] : null;
                NibbleArray dataBase = new NibbleArray(4096);
                NibbleArray dataExtra = storage.hasBlockDataExtras() ? new NibbleArray(4096) : null;
                List<byte[]> dataHuge = this.saveData(storage, idsBase, idsExtra, dataBase, dataExtra);
                storageTag.putByteArray("Blocks", idsBase);
                storageTag.putByteArray("Data", dataBase.getData());
                if (idsExtra != null) {
                    storageTag.putByteArray("BlocksExtra", idsExtra);
                }
                if (dataExtra != null) {
                    storageTag.putByteArray("DataExtra", dataExtra.getData());
                }
                if (dataHuge != null) {
                    ListTag<ByteArrayTag> hugeDataListTag = new ListTag<ByteArrayTag>(HUGE_TAG_NAME);
                    for (byte[] hugeData : dataHuge) {
                        hugeDataListTag.add(new ByteArrayTag("", hugeData));
                    }
                    storageTag.putList(hugeDataListTag);
                }
            }
            if (version < 7) continue;
            storageList.add(storageTag);
        }
        s.putByte("Version", version);
        s.putByte("ContentVersion", this.getContentVersion());
        if (version >= 7) {
            s.putList(storageList);
        }
        s.putByteArray("BlockLight", this.blockLight == null ? this.getLightArray() : this.blockLight);
        s.putByteArray("SkyLight", this.skyLight == null ? this.getSkyLightArray() : this.skyLight);
        return s;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public synchronized void compressStorageLayers() {
        this.layerStorage.compress(this::setLayerStorage);
    }

    public boolean compress() {
        if (this.blockLight != null) {
            byte[] arr2;
            byte[] arr1 = this.blockLight;
            boolean bl = this.hasBlockLight = !Utils.isByteArrayEmpty(arr1);
            if (this.skyLight != null) {
                arr2 = this.skyLight;
                this.hasSkyLight = !Utils.isByteArrayEmpty(arr2);
            } else if (this.hasSkyLight) {
                arr2 = EmptyChunkSection.EMPTY_SKY_LIGHT_ARR;
            } else {
                arr2 = EmptyChunkSection.EMPTY_LIGHT_ARR;
                this.hasSkyLight = false;
            }
            this.blockLight = null;
            this.skyLight = null;
            byte[] toDeflate = null;
            if (this.hasBlockLight && this.hasSkyLight && arr2 != EmptyChunkSection.EMPTY_SKY_LIGHT_ARR) {
                toDeflate = Binary.appendBytes(arr1, (byte[][])new byte[][]{arr2});
            } else if (this.hasBlockLight) {
                toDeflate = arr1;
            }
            if (toDeflate != null) {
                try {
                    this.compressedLight = Zlib.deflate(toDeflate, 1);
                }
                catch (Exception e) {
                    log.error("Error compressing the light data", (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public synchronized List<Block> scanBlocks(LevelProvider provider, int offsetX, int offsetZ, BlockVector3 min, BlockVector3 max, BiPredicate<BlockVector3, BlockState> condition) {
        BlockStorage storage = this.layerStorage.getStorageOrNull(0);
        if (storage == null) {
            return Collections.emptyList();
        }
        ArrayList<Block> results = new ArrayList<Block>();
        BlockVector3 current = new BlockVector3();
        int offsetY = this.getY() << 4;
        int minX = Math.max(0, min.x - offsetX);
        int minY = Math.max(0, min.y - offsetY);
        int minZ = Math.max(0, min.z - offsetZ);
        for (int x = Math.min(max.x - offsetX, 15); x >= minX; --x) {
            current.x = offsetX + x;
            for (int z = Math.min(max.z - offsetZ, 15); z >= minZ; --z) {
                current.z = offsetZ + z;
                for (int y = Math.min(max.y - offsetY, 15); y >= minY; --y) {
                    current.y = offsetY + y;
                    BlockState state = storage.getBlockState(x, y, z);
                    if (!condition.test(current, state)) continue;
                    results.add(state.getBlockRepairing(provider.getLevel(), current, 0));
                }
            }
        }
        return results;
    }

    @Override
    @Nonnull
    public ChunkSection copy() {
        return new ChunkSection(this.y, this.layerStorage.clone(), this.blockLight == null ? null : (byte[])this.blockLight.clone(), this.skyLight == null ? null : (byte[])this.skyLight.clone(), this.compressedLight == null ? null : (byte[])this.compressedLight.clone(), this.hasBlockLight, this.hasSkyLight);
    }

    @Override
    @PowerNukkitOnly
    public int getMaximumLayer() {
        return 1;
    }

    @Override
    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.0.0-PN")
    public int getContentVersion() {
        return this.contentVersion;
    }

    @Override
    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.1.0-PN")
    public void setContentVersion(int contentVersion) {
        this.contentVersion = contentVersion;
    }

    @Override
    @PowerNukkitOnly
    public boolean hasBlocks() {
        return this.layerStorage.hasBlocks();
    }
}

