/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.generic.serializer;

import cn.nukkit.api.Since;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.DimensionData;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.generic.BaseChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.util.PalettedBlockStorage;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.ThreadCache;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.function.BiConsumer;

@Since(value="1.6.0.0-PN")
public class NetworkChunkSerializer {
    private static final int EXTENDED_NEGATIVE_SUB_CHUNKS = 4;
    private static final byte[] negativeSubChunks;

    @Since(value="1.6.0.0-PN")
    public static void serialize(BaseChunk chunk, BiConsumer<BinaryStream, Integer> callback, DimensionData dimensionData) {
        byte[] blockEntities = chunk.getBlockEntities().isEmpty() ? new byte[]{} : NetworkChunkSerializer.serializeEntities(chunk);
        int subChunkCount = 0;
        ChunkSection[] sections = chunk.getSections();
        for (int i = sections.length - 1; i >= 0; --i) {
            if (sections[i].isEmpty()) continue;
            subChunkCount = i + 1;
            break;
        }
        int maxDimensionSections = dimensionData.getHeight() >> 4;
        subChunkCount = Math.min(maxDimensionSections, subChunkCount);
        byte[] biomePalettes = NetworkChunkSerializer.convert2DBiomesTo3D(chunk, maxDimensionSections);
        BinaryStream stream = ((BinaryStream)ThreadCache.binaryStream.get()).reset();
        int writtenSections = subChunkCount;
        if (dimensionData.getDimensionId() == 0 && subChunkCount < maxDimensionSections) {
            stream.put(negativeSubChunks);
            writtenSections += 4;
        }
        for (int i = 0; i < subChunkCount; ++i) {
            sections[i].writeTo(stream);
        }
        stream.put(biomePalettes);
        stream.putByte((byte)0);
        stream.put(blockEntities);
        callback.accept(stream, writtenSections);
    }

    private static byte[] serializeEntities(BaseChunk chunk) {
        ObjectArrayList tagList = new ObjectArrayList();
        for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
            if (!(blockEntity instanceof BlockEntitySpawnable)) continue;
            tagList.add(((BlockEntitySpawnable)blockEntity).getSpawnCompound());
        }
        try {
            return NBTIO.write((Collection<CompoundTag>)tagList, ByteOrder.LITTLE_ENDIAN, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] convert2DBiomesTo3D(BaseFullChunk chunk, int sections) {
        PalettedBlockStorage palette = PalettedBlockStorage.createWithDefaultState(Biome.getBiomeIdOrCorrect(chunk.getBiomeId(0, 0)));
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int biomeId = Biome.getBiomeIdOrCorrect(chunk.getBiomeId(x, z));
                for (int y = 0; y < 16; ++y) {
                    palette.setBlock(x, y, z, biomeId);
                }
            }
        }
        BinaryStream stream = ((BinaryStream)ThreadCache.binaryStream.get()).reset();
        palette.writeTo(stream);
        byte[] bytes = stream.getBuffer();
        stream.reset();
        for (int i = 0; i < sections; ++i) {
            stream.put(bytes);
        }
        return stream.getBuffer();
    }

    static {
        BinaryStream stream = new BinaryStream();
        for (int i = 0; i < 4; ++i) {
            stream.putByte((byte)8);
            stream.putByte((byte)0);
        }
        negativeSubChunks = stream.getBuffer();
    }
}

