/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.updater;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.updater.Updater;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
class OldWoodBarkUpdater
implements Updater {
    private final ChunkSection section;
    private final int fromLog;
    private final int increment;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public OldWoodBarkUpdater(ChunkSection section, int fromLog, int increment) {
        this.section = section;
        this.fromLog = fromLog;
        this.increment = increment;
    }

    @Override
    @PowerNukkitOnly
    public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, BlockState state) {
        if (state.getBlockId() != this.fromLog) {
            return false;
        }
        int legacyDamage = state.getLegacyDamage();
        if ((legacyDamage & 0xC) != 12) {
            return false;
        }
        this.section.setBlockState(x, y, z, BlockState.of(17, (legacyDamage & 3) + this.increment));
        return true;
    }
}

