/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.updater;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSnowLayer;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.updater.Updater;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class SnowLayerUpdater
implements Updater {
    private final Level level;
    private final ChunkSection section;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public SnowLayerUpdater(Level level, ChunkSection section) {
        this.level = level;
        this.section = section;
    }

    @Override
    @PowerNukkitOnly
    public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, BlockState state) {
        if (state.getBlockId() != 78) {
            return false;
        }
        if (y > 0) {
            if (this.section.getBlockId(x, y - 1, z) == 2) {
                this.section.setBlockState(x, y, z, state.withProperty(BlockSnowLayer.COVERED, true));
                return true;
            }
        } else if (offsetY == 0) {
            return false;
        }
        if (this.level.getBlockIdAt(offsetX + x, offsetY + y - 1, offsetZ + z, 0) == 2) {
            this.section.setBlockState(x, y, z, state.withProperty(BlockSnowLayer.COVERED, true));
            return true;
        }
        return false;
    }
}

