/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.updater;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockWall;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.updater.ChunkUpdater;
import cn.nukkit.level.format.updater.Updater;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
class WallUpdater
implements Updater {
    private static final Logger log = LogManager.getLogger(WallUpdater.class);
    private final Level level;
    private final ChunkSection section;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public WallUpdater(Level level, ChunkSection section) {
        this.level = level;
        this.section = section;
    }

    @Override
    @PowerNukkitOnly
    public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, BlockState state) {
        Block block;
        if (state.getBlockId() != 139) {
            return false;
        }
        int levelX = offsetX + x;
        int levelY = offsetY + y;
        int levelZ = offsetZ + z;
        try {
            block = state.getBlock(this.level, levelX, levelY, levelZ, 0);
        }
        catch (InvalidBlockStateException e) {
            try {
                int data = state.getLegacyDamage() & 0xF;
                try {
                    BlockWall.WALL_BLOCK_TYPE.validateMeta(data, 0);
                }
                catch (InvalidBlockPropertyMetaException ignored) {
                    data = 0;
                }
                block = state.withData(data).getBlock(this.level, levelX, levelY, levelZ, 0);
            }
            catch (InvalidBlockStateException e2) {
                e.addSuppressed(e2);
                Server server = Server.getInstance();
                log.warn("Failed to update the block X:{}, Y:{}, Z:{} at {}, could not cast it to BlockWall. Section Version:{}, Updating To:{}, Server Version:{} {}", (Object)levelX, (Object)levelY, (Object)levelZ, (Object)this.level, (Object)this.section.getContentVersion(), (Object)ChunkUpdater.getCurrentContentVersion(), (Object)server.getNukkitVersion(), (Object)server.getGitCommit(), (Object)e);
                return false;
            }
        }
        BlockWall blockWall = (BlockWall)block;
        if (blockWall.autoConfigureState()) {
            this.section.setBlockStateAtLayer(x, y, z, 0, blockWall.getCurrentState());
            return true;
        }
        return false;
    }
}

