/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator;

import cn.nukkit.block.Block;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.level.generator.object.ore.OreType;
import cn.nukkit.level.generator.populator.impl.PopulatorOre;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Flat
extends Generator {
    @Generated
    private static final Logger log = LogManager.getLogger(Flat.class);
    private ChunkManager level;
    private NukkitRandom random;
    private final List<Populator> populators = new ArrayList<Populator>();
    private int[][] structure;
    private final Map<String, Object> options;
    private int floorLevel;
    private String preset = "2;7,2x3,2;1;";
    private boolean init = false;
    private int biome;

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public ChunkManager getChunkManager() {
        return this.level;
    }

    @Override
    public Map<String, Object> getSettings() {
        return this.options;
    }

    @Override
    public String getName() {
        return "flat";
    }

    public Flat() {
        this(new HashMap<String, Object>());
    }

    public Flat(Map<String, Object> options) {
        this.options = options;
        if (this.options.containsKey("decoration")) {
            PopulatorOre ores = new PopulatorOre(1, new OreType[]{new OreType(Block.get(16), 20, 16, 0, 128), new OreType(Block.get(15), 20, 8, 0, 64), new OreType(Block.get(73), 8, 7, 0, 16), new OreType(Block.get(21), 1, 6, 0, 32), new OreType(Block.get(14), 2, 8, 0, 32), new OreType(Block.get(56), 1, 7, 0, 16), new OreType(Block.get(3), 20, 32, 0, 128), new OreType(Block.get(13), 20, 16, 0, 128)});
            this.populators.add(ores);
        }
    }

    protected void parsePreset(String preset, int chunkX, int chunkZ) {
        try {
            this.preset = preset;
            String[] presetArray = preset.split(";");
            int version = Integer.parseInt(presetArray[0]);
            String blocks = presetArray.length > 1 ? presetArray[1] : "";
            this.biome = presetArray.length > 2 ? Integer.parseInt(presetArray[2]) : 1;
            String options = presetArray.length > 3 ? presetArray[1] : "";
            this.structure = new int[256][];
            int y = 0;
            for (String block : blocks.split(",")) {
                int id;
                int meta = 0;
                int cnt = 1;
                if (Pattern.matches("^[0-9]{1,3}x[0-9]$", block)) {
                    String[] s = block.split("x");
                    cnt = Integer.parseInt(s[0]);
                    id = Integer.parseInt(s[1]);
                } else if (Pattern.matches("^[0-9]{1,3}:[0-9]{0,2}$", block)) {
                    String[] s = block.split(":");
                    id = Integer.parseInt(s[0]);
                    meta = Integer.parseInt(s[1]);
                } else {
                    if (!Pattern.matches("^[0-9]{1,3}$", block)) continue;
                    id = Integer.parseInt(block);
                }
                int cY = y;
                if ((y += cnt) > 255) {
                    y = 255;
                }
                while (cY < y) {
                    this.structure[cY] = new int[]{id, meta};
                    ++cY;
                }
            }
            this.floorLevel = y;
            while (y <= 255) {
                this.structure[y] = new int[]{0, 0};
                ++y;
            }
            for (String option : options.split(",")) {
                if (Pattern.matches("^[0-9a-z_]+$", option)) {
                    this.options.put(option, true);
                    continue;
                }
                if (!Pattern.matches("^[0-9a-z_]+\\([0-9a-z_ =]+\\)$", option)) continue;
                String name = option.substring(0, option.indexOf("("));
                String extra = option.substring(option.indexOf("(") + 1, option.indexOf(")"));
                HashMap<String, Float> map = new HashMap<String, Float>();
                for (String kv : extra.split(" ")) {
                    String[] data = kv.split("=");
                    map.put(data[0], Float.valueOf(data[1]));
                }
                this.options.put(name, map);
            }
        }
        catch (Exception e) {
            log.error("error while parsing the preset", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init(ChunkManager level, NukkitRandom random) {
        this.level = level;
        this.random = random;
    }

    @Override
    public void generateChunk(int chunkX, int chunkZ) {
        if (!this.init) {
            this.init = true;
            if (this.options.containsKey("preset") && !"".equals(this.options.get("preset"))) {
                this.parsePreset((String)this.options.get("preset"), chunkX, chunkZ);
            } else {
                this.parsePreset(this.preset, chunkX, chunkZ);
            }
        }
        this.generateChunk(this.level.getChunk(chunkX, chunkZ));
    }

    private void generateChunk(FullChunk chunk) {
        chunk.setGenerated();
        for (int Z = 0; Z < 16; ++Z) {
            for (int X = 0; X < 16; ++X) {
                chunk.setBiomeId(X, Z, this.biome);
                for (int y = 0; y < 256; ++y) {
                    int k = this.structure[y][0];
                    int l = this.structure[y][1];
                    chunk.setBlock(X, y, Z, this.structure[y][0], this.structure[y][1]);
                }
            }
        }
    }

    @Override
    public void populateChunk(int chunkX, int chunkZ) {
        BaseFullChunk chunk = this.level.getChunk(chunkX, chunkZ);
        this.random.setSeed((long)(0xDEADBEEF ^ chunkX << 8 ^ chunkZ) ^ this.level.getSeed());
        for (Populator populator : this.populators) {
            populator.populate(this.level, chunkX, chunkZ, this.random, chunk);
        }
    }

    @Override
    public Vector3 getSpawn() {
        return new Vector3(128.0, this.floorLevel, 128.0);
    }
}

