/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator;

import cn.nukkit.api.Since;
import cn.nukkit.block.BlockID;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.DimensionData;
import cn.nukkit.level.DimensionEnum;
import cn.nukkit.level.generator.Normal;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import java.util.HashMap;
import java.util.Map;

public abstract class Generator
implements BlockID {
    public static final int TYPE_OLD = 0;
    public static final int TYPE_INFINITE = 1;
    public static final int TYPE_FLAT = 2;
    public static final int TYPE_NETHER = 3;
    private static final Map<String, Class<? extends Generator>> nameList = new HashMap<String, Class<? extends Generator>>();
    private static final Map<Integer, Class<? extends Generator>> typeList = new HashMap<Integer, Class<? extends Generator>>();

    public abstract int getId();

    @Since(value="1.6.0.0-PN")
    public DimensionData getDimensionData() {
        DimensionData dimensionData = DimensionEnum.getDataFromId(this.getDimension());
        if (dimensionData == null) {
            dimensionData = DimensionEnum.OVERWORLD.getDimensionData();
        }
        return dimensionData;
    }

    @Deprecated
    public int getDimension() {
        return 0;
    }

    public static boolean addGenerator(Class<? extends Generator> clazz, String name, int type) {
        name = name.toLowerCase();
        if (clazz != null && !nameList.containsKey(name)) {
            nameList.put(name, clazz);
            if (!typeList.containsKey(type)) {
                typeList.put(type, clazz);
            }
            return true;
        }
        return false;
    }

    public static String[] getGeneratorList() {
        String[] keys = new String[nameList.size()];
        return nameList.keySet().toArray(keys);
    }

    public static Class<? extends Generator> getGenerator(String name) {
        if (nameList.containsKey(name = name.toLowerCase())) {
            return nameList.get(name);
        }
        return Normal.class;
    }

    public static Class<? extends Generator> getGenerator(int type) {
        if (typeList.containsKey(type)) {
            return typeList.get(type);
        }
        return Normal.class;
    }

    public static String getGeneratorName(Class<? extends Generator> c) {
        for (String key : nameList.keySet()) {
            if (!nameList.get(key).equals(c)) continue;
            return key;
        }
        return "unknown";
    }

    public static int getGeneratorType(Class<? extends Generator> c) {
        for (int key : typeList.keySet()) {
            if (!typeList.get(key).equals(c)) continue;
            return key;
        }
        return 1;
    }

    public abstract void init(ChunkManager var1, NukkitRandom var2);

    public abstract void generateChunk(int var1, int var2);

    public abstract void populateChunk(int var1, int var2);

    public abstract Map<String, Object> getSettings();

    public abstract String getName();

    public abstract Vector3 getSpawn();

    public abstract ChunkManager getChunkManager();
}

