/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.network.Network;
import cn.nukkit.network.protocol.BatchPacket;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.BinaryStream;
import com.nukkitx.network.raknet.RakNetReliability;

public abstract class DataPacket
extends BinaryStream
implements Cloneable {
    @PowerNukkitOnly
    public static final DataPacket[] EMPTY_ARRAY = new DataPacket[0];
    public volatile boolean isEncoded = false;
    private int channel = 0;
    public RakNetReliability reliability = RakNetReliability.RELIABLE_ORDERED;

    public abstract byte pid();

    public abstract void decode();

    public abstract void encode();

    public final void tryEncode() {
        if (!this.isEncoded) {
            this.isEncoded = true;
            this.encode();
        }
    }

    @Override
    public DataPacket reset() {
        super.reset();
        this.putUnsignedVarInt(this.pid() & 0xFF);
        return this;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public int getChannel() {
        return this.channel;
    }

    public DataPacket clean() {
        this.setBuffer(null);
        this.setOffset(0);
        this.isEncoded = false;
        return this;
    }

    public DataPacket clone() {
        try {
            return (DataPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public BatchPacket compress() {
        return this.compress(Server.getInstance().networkCompressionLevel);
    }

    public BatchPacket compress(int level) {
        BatchPacket batch = new BatchPacket();
        byte[][] batchPayload = new byte[2][];
        byte[] buf = this.getBuffer();
        batchPayload[0] = Binary.writeUnsignedVarInt(buf.length);
        batchPayload[1] = buf;
        try {
            batch.payload = Network.deflateRaw(batchPayload, level);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return batch;
    }
}

