/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import lombok.Generated;

public class MoveEntityDeltaPacket
extends DataPacket {
    public static final byte NETWORK_ID = 111;
    public static final int FLAG_HAS_X = 1;
    public static final int FLAG_HAS_Y = 2;
    public static final int FLAG_HAS_Z = 4;
    public static final int FLAG_HAS_PITCH = 8;
    public static final int FLAG_HAS_YAW = 16;
    public static final int FLAG_HAS_HEAD_YAW = 32;
    @Since(value="1.6.0.0-PN")
    public static final int FLAG_ON_GROUND = 64;
    @Since(value="1.6.0.0-PN")
    public static final int FLAG_TELEPORTING = 128;
    @Since(value="1.6.0.0-PN")
    public static final int FLAG_FORCE_MOVE_LOCAL_ENTITY = 256;
    @Since(value="1.6.0.0-PN")
    public long runtimeEntityId;
    public int flags = 0;
    @Since(value="1.4.0.0-PN")
    public float x = 0.0f;
    @Since(value="1.4.0.0-PN")
    public float y = 0.0f;
    @Since(value="1.4.0.0-PN")
    public float z = 0.0f;
    @Since(value="1.6.0.0-PN")
    public float pitch = 0.0f;
    @Since(value="1.6.0.0-PN")
    public float yaw = 0.0f;
    @Since(value="1.6.0.0-PN")
    public float headYaw = 0.0f;

    @Override
    public byte pid() {
        return 111;
    }

    @Override
    public void decode() {
        this.runtimeEntityId = this.getEntityRuntimeId();
        this.flags = this.getLShort();
        if ((this.flags & 1) != 0) {
            this.x = this.getCoordinate();
        }
        if ((this.flags & 2) != 0) {
            this.y = this.getCoordinate();
        }
        if ((this.flags & 4) != 0) {
            this.z = this.getCoordinate();
        }
        if ((this.flags & 8) != 0) {
            this.pitch = this.getRotation();
        }
        if ((this.flags & 0x10) != 0) {
            this.yaw = this.getRotation();
        }
        if ((this.flags & 0x20) != 0) {
            this.headYaw = this.getRotation();
        }
    }

    @Override
    public void encode() {
        this.reset();
        this.putEntityRuntimeId(this.runtimeEntityId);
        this.putLShort(this.flags);
        if ((this.flags & 1) != 0) {
            this.putCoordinate(this.x);
        }
        if ((this.flags & 2) != 0) {
            this.putCoordinate(this.y);
        }
        if ((this.flags & 4) != 0) {
            this.putCoordinate(this.z);
        }
        if ((this.flags & 8) != 0) {
            this.putRotation(this.pitch);
        }
        if ((this.flags & 0x10) != 0) {
            this.putRotation(this.yaw);
        }
        if ((this.flags & 0x20) != 0) {
            this.putRotation(this.headYaw);
        }
    }

    private float getCoordinate() {
        return this.getLFloat();
    }

    private void putCoordinate(float value) {
        this.putLFloat(value);
    }

    private float getRotation() {
        return (float)this.getByte() * 1.40625f;
    }

    private void putRotation(float value) {
        this.putByte((byte)(value / 1.40625f));
    }

    @Since(value="1.6.0.0-PN")
    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Generated
    public String toString() {
        return "MoveEntityDeltaPacket(runtimeEntityId=" + this.runtimeEntityId + ", flags=" + this.flags + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", pitch=" + this.pitch + ", yaw=" + this.yaw + ", headYaw=" + this.headYaw + ")";
    }
}

