/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Since(value="1.3.0.0-PN")
public class PlayerEnchantOptionsPacket
extends DataPacket {
    public static final byte NETWORK_ID = -110;
    @Since(value="1.3.0.0-PN")
    public final List<EnchantOptionData> options = new ArrayList<EnchantOptionData>();

    @Override
    public byte pid() {
        return -110;
    }

    @Override
    public void decode() {
        int size = (int)this.getUnsignedVarInt();
        for (int i = 0; i < size; ++i) {
            int minLevel = this.getVarInt();
            int slot = this.getInt();
            int eSize = (int)this.getUnsignedVarInt();
            ObjectArrayList list1 = new ObjectArrayList();
            for (int j = 0; j < eSize; ++j) {
                EnchantData data = new EnchantData(this.getByte(), this.getByte());
                list1.add(data);
            }
            eSize = (int)this.getUnsignedVarInt();
            ObjectArrayList list2 = new ObjectArrayList();
            for (int j = 0; j < eSize; ++j) {
                EnchantData data = new EnchantData(this.getByte(), this.getByte());
                list2.add(data);
            }
            eSize = (int)this.getUnsignedVarInt();
            ObjectArrayList list3 = new ObjectArrayList();
            for (int j = 0; j < eSize; ++j) {
                EnchantData data = new EnchantData(this.getByte(), this.getByte());
                list3.add(data);
            }
            String enchantName = this.getString();
            int eNetId = (int)this.getUnsignedVarInt();
            this.options.add(new EnchantOptionData(minLevel, slot, (List<EnchantData>)list1, (List<EnchantData>)list2, (List<EnchantData>)list3, enchantName, eNetId));
        }
    }

    @Override
    public void encode() {
        this.reset();
        this.putUnsignedVarInt(this.options.size());
        for (EnchantOptionData option : this.options) {
            this.putVarInt(option.getMinLevel());
            this.putInt(option.getPrimarySlot());
            this.putUnsignedVarInt(option.getEnchants0().size());
            for (EnchantData data : option.getEnchants0()) {
                this.putByte((byte)data.getType());
                this.putByte((byte)data.getLevel());
            }
            this.putUnsignedVarInt(option.getEnchants1().size());
            for (EnchantData data : option.getEnchants1()) {
                this.putByte((byte)data.getType());
                this.putByte((byte)data.getLevel());
            }
            this.putUnsignedVarInt(option.getEnchants2().size());
            for (EnchantData data : option.getEnchants2()) {
                this.putByte((byte)data.getType());
                this.putByte((byte)data.getLevel());
            }
            this.putString(option.getEnchantName());
            this.putUnsignedVarInt(option.getEnchantNetId());
        }
    }

    @Generated
    public String toString() {
        return "PlayerEnchantOptionsPacket(options=" + this.options + ")";
    }

    @Since(value="1.3.0.0-PN")
    public final class EnchantData {
        private final int type;
        private final int level;

        @Generated
        public EnchantData(int type, int level) {
            this.type = type;
            this.level = level;
        }

        @Generated
        public int getType() {
            return this.type;
        }

        @Generated
        public int getLevel() {
            return this.level;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnchantData)) {
                return false;
            }
            EnchantData other = (EnchantData)o;
            if (this.getType() != other.getType()) {
                return false;
            }
            return this.getLevel() == other.getLevel();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            result = result * 59 + this.getLevel();
            return result;
        }

        @Generated
        public String toString() {
            return "PlayerEnchantOptionsPacket.EnchantData(type=" + this.getType() + ", level=" + this.getLevel() + ")";
        }
    }

    @Since(value="1.3.0.0-PN")
    public final class EnchantOptionData {
        @Since(value="1.3.1.0-PN")
        private final int minLevel;
        private final int primarySlot;
        private final List<EnchantData> enchants0;
        private final List<EnchantData> enchants1;
        private final List<EnchantData> enchants2;
        private final String enchantName;
        private final int enchantNetId;

        @Generated
        public EnchantOptionData(int minLevel, int primarySlot, List<EnchantData> enchants0, List<EnchantData> enchants1, List<EnchantData> enchants2, String enchantName, int enchantNetId) {
            this.minLevel = minLevel;
            this.primarySlot = primarySlot;
            this.enchants0 = enchants0;
            this.enchants1 = enchants1;
            this.enchants2 = enchants2;
            this.enchantName = enchantName;
            this.enchantNetId = enchantNetId;
        }

        @Generated
        public int getMinLevel() {
            return this.minLevel;
        }

        @Generated
        public int getPrimarySlot() {
            return this.primarySlot;
        }

        @Generated
        public List<EnchantData> getEnchants0() {
            return this.enchants0;
        }

        @Generated
        public List<EnchantData> getEnchants1() {
            return this.enchants1;
        }

        @Generated
        public List<EnchantData> getEnchants2() {
            return this.enchants2;
        }

        @Generated
        public String getEnchantName() {
            return this.enchantName;
        }

        @Generated
        public int getEnchantNetId() {
            return this.enchantNetId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnchantOptionData)) {
                return false;
            }
            EnchantOptionData other = (EnchantOptionData)o;
            if (this.getMinLevel() != other.getMinLevel()) {
                return false;
            }
            if (this.getPrimarySlot() != other.getPrimarySlot()) {
                return false;
            }
            List<EnchantData> this$enchants0 = this.getEnchants0();
            List<EnchantData> other$enchants0 = other.getEnchants0();
            if (this$enchants0 == null ? other$enchants0 != null : !((Object)this$enchants0).equals(other$enchants0)) {
                return false;
            }
            List<EnchantData> this$enchants1 = this.getEnchants1();
            List<EnchantData> other$enchants1 = other.getEnchants1();
            if (this$enchants1 == null ? other$enchants1 != null : !((Object)this$enchants1).equals(other$enchants1)) {
                return false;
            }
            List<EnchantData> this$enchants2 = this.getEnchants2();
            List<EnchantData> other$enchants2 = other.getEnchants2();
            if (this$enchants2 == null ? other$enchants2 != null : !((Object)this$enchants2).equals(other$enchants2)) {
                return false;
            }
            String this$enchantName = this.getEnchantName();
            String other$enchantName = other.getEnchantName();
            if (this$enchantName == null ? other$enchantName != null : !this$enchantName.equals(other$enchantName)) {
                return false;
            }
            return this.getEnchantNetId() == other.getEnchantNetId();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinLevel();
            result = result * 59 + this.getPrimarySlot();
            List<EnchantData> $enchants0 = this.getEnchants0();
            result = result * 59 + ($enchants0 == null ? 43 : ((Object)$enchants0).hashCode());
            List<EnchantData> $enchants1 = this.getEnchants1();
            result = result * 59 + ($enchants1 == null ? 43 : ((Object)$enchants1).hashCode());
            List<EnchantData> $enchants2 = this.getEnchants2();
            result = result * 59 + ($enchants2 == null ? 43 : ((Object)$enchants2).hashCode());
            String $enchantName = this.getEnchantName();
            result = result * 59 + ($enchantName == null ? 43 : $enchantName.hashCode());
            result = result * 59 + this.getEnchantNetId();
            return result;
        }

        @Generated
        public String toString() {
            return "PlayerEnchantOptionsPacket.EnchantOptionData(minLevel=" + this.getMinLevel() + ", primarySlot=" + this.getPrimarySlot() + ", enchants0=" + this.getEnchants0() + ", enchants1=" + this.getEnchants1() + ", enchants2=" + this.getEnchants2() + ", enchantName=" + this.getEnchantName() + ", enchantNetId=" + this.getEnchantNetId() + ")";
        }
    }
}

