/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.resourcepacks.ResourcePack;
import java.util.Arrays;
import lombok.Generated;

public class ResourcePacksInfoPacket
extends DataPacket {
    public static final byte NETWORK_ID = 6;
    public boolean mustAccept;
    public boolean scripting;
    @Since(value="1.6.0.0-PN")
    public boolean forceServerPacks;
    public ResourcePack[] behaviourPackEntries = ResourcePack.EMPTY_ARRAY;
    public ResourcePack[] resourcePackEntries = ResourcePack.EMPTY_ARRAY;

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
        this.reset();
        this.putBoolean(this.mustAccept);
        this.putBoolean(this.scripting);
        this.putBoolean(this.forceServerPacks);
        this.encodePacks(this.behaviourPackEntries, true);
        this.encodePacks(this.resourcePackEntries, false);
    }

    private void encodePacks(ResourcePack[] packs, boolean behaviour) {
        this.putLShort(packs.length);
        for (ResourcePack entry : packs) {
            this.putString(entry.getPackId().toString());
            this.putString(entry.getPackVersion());
            this.putLLong(entry.getPackSize());
            this.putString("");
            this.putString("");
            this.putString(entry.getPackId().toString());
            this.putBoolean(false);
            if (behaviour) continue;
            this.putBoolean(false);
        }
    }

    @Override
    public byte pid() {
        return 6;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public boolean isForcedToAccept() {
        return this.mustAccept;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setForcedToAccept(boolean mustAccept) {
        this.mustAccept = mustAccept;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public boolean isScriptingEnabled() {
        return this.scripting;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setScriptingEnabled(boolean scripting) {
        this.scripting = scripting;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public ResourcePack[] getBehaviourPackEntries() {
        return this.behaviourPackEntries;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setBehaviourPackEntries(ResourcePack[] behaviourPackEntries) {
        this.behaviourPackEntries = behaviourPackEntries;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public ResourcePack[] getResourcePackEntries() {
        return this.resourcePackEntries;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setResourcePackEntries(ResourcePack[] resourcePackEntries) {
        this.resourcePackEntries = resourcePackEntries;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public boolean isForcingServerPacksEnabled() {
        return this.forceServerPacks;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setForcingServerPacksEnabled(boolean forcingServerPacksEnabled) {
        this.forceServerPacks = forcingServerPacksEnabled;
    }

    @Generated
    public String toString() {
        return "ResourcePacksInfoPacket(mustAccept=" + this.mustAccept + ", scripting=" + this.scripting + ", forceServerPacks=" + this.forceServerPacks + ", behaviourPackEntries=" + Arrays.deepToString(this.getBehaviourPackEntries()) + ", resourcePackEntries=" + Arrays.deepToString(this.getResourcePackEntries()) + ")";
    }
}

