/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import javax.annotation.Nonnull;
import lombok.Generated;

public class SetTitlePacket
extends DataPacket {
    public static final byte NETWORK_ID = 88;
    private static final TitleAction[] TITLE_ACTIONS = TitleAction.values();
    public static final int TYPE_CLEAR = 0;
    public static final int TYPE_RESET = 1;
    public static final int TYPE_TITLE = 2;
    public static final int TYPE_SUBTITLE = 3;
    public static final int TYPE_ACTION_BAR = 4;
    public static final int TYPE_ANIMATION_TIMES = 5;
    public int type;
    public String text = "";
    public int fadeInTime = 0;
    public int stayTime = 0;
    public int fadeOutTime = 0;
    @Since(value="1.6.0.0-PN")
    public String xuid = "";
    @Since(value="1.6.0.0-PN")
    public String platformOnlineId = "";

    @Override
    public byte pid() {
        return 88;
    }

    @Override
    public void decode() {
        this.type = this.getVarInt();
        this.text = this.getString();
        this.fadeInTime = this.getVarInt();
        this.stayTime = this.getVarInt();
        this.fadeOutTime = this.getVarInt();
        this.xuid = this.getString();
        this.platformOnlineId = this.getString();
    }

    @Override
    public void encode() {
        this.reset();
        this.putVarInt(this.type);
        this.putString(this.text);
        this.putVarInt(this.fadeInTime);
        this.putVarInt(this.stayTime);
        this.putVarInt(this.fadeOutTime);
        this.putString(this.xuid);
        this.putString(this.platformOnlineId);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public TitleAction getTitleAction() {
        int currentType = this.type;
        if (currentType >= 0 && currentType < TITLE_ACTIONS.length) {
            return TITLE_ACTIONS[currentType];
        }
        throw new UnsupportedOperationException("Bad type: " + currentType);
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setTitleAction(@Nonnull TitleAction type) {
        this.type = type.ordinal();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public String getText() {
        return this.text;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setText(@Nonnull String text) {
        this.text = text;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public int getFadeInTime() {
        return this.fadeInTime;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setFadeInTime(int fadeInTime) {
        this.fadeInTime = fadeInTime;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public int getStayTime() {
        return this.stayTime;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setStayTime(int stayTime) {
        this.stayTime = stayTime;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public int getFadeOutTime() {
        return this.fadeOutTime;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setFadeOutTime(int fadeOutTime) {
        this.fadeOutTime = fadeOutTime;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public String getXuid() {
        return this.xuid;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setXuid(String xuid) {
        this.xuid = xuid;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public String getPlatformOnlineId() {
        return this.platformOnlineId;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setPlatformOnlineId(String platformOnlineId) {
        this.platformOnlineId = platformOnlineId;
    }

    @Generated
    public String toString() {
        return "SetTitlePacket(type=" + this.type + ", text=" + this.getText() + ", fadeInTime=" + this.getFadeInTime() + ", stayTime=" + this.getStayTime() + ", fadeOutTime=" + this.getFadeOutTime() + ", xuid=" + this.getXuid() + ", platformOnlineId=" + this.getPlatformOnlineId() + ")";
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public static enum TitleAction {
        CLEAR,
        RESET,
        SET_TITLE_MESSAGE,
        SET_SUBTITLE_MESSAGE,
        SET_ACTION_BAR_MESSAGE,
        SET_ANIMATION_TIMES,
        SET_TITLE_JSON,
        SET_SUBTITLE_JSON,
        SET_ACTIONBAR_JSON;

    }
}

