/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.rcon;

import cn.nukkit.network.rcon.RCONCommand;
import cn.nukkit.network.rcon.RCONPacket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RCONServer
extends Thread {
    @Generated
    private static final Logger log = LogManager.getLogger(RCONServer.class);
    private static final int SERVERDATA_AUTH = 3;
    private static final int SERVERDATA_AUTH_RESPONSE = 2;
    private static final int SERVERDATA_EXECCOMMAND = 2;
    private static final int SERVERDATA_RESPONSE_VALUE = 0;
    private volatile boolean running;
    private ServerSocketChannel serverChannel;
    private Selector selector;
    private String password;
    private final Set<SocketChannel> rconSessions = new HashSet<SocketChannel>();
    private final List<RCONCommand> receiveQueue = new ArrayList<RCONCommand>();
    private final Map<SocketChannel, List<RCONPacket>> sendQueues = new HashMap<SocketChannel, List<RCONPacket>>();

    public RCONServer(String address, int port, String password) throws IOException {
        this.setName("RCON");
        this.running = true;
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        this.serverChannel.socket().bind(new InetSocketAddress(address, port));
        this.selector = SelectorProvider.provider().openSelector();
        this.serverChannel.register(this.selector, 16);
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RCONCommand receive() {
        List<RCONCommand> list = this.receiveQueue;
        synchronized (list) {
            if (!this.receiveQueue.isEmpty()) {
                RCONCommand command = this.receiveQueue.get(0);
                this.receiveQueue.remove(0);
                return command;
            }
            return null;
        }
    }

    public void respond(SocketChannel channel, int id, String response) {
        this.send(channel, new RCONPacket(id, 0, response.getBytes()));
    }

    public void close() {
        this.running = false;
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        while (this.running) {
            try {
                object = this.sendQueues;
                synchronized (object) {
                    for (SocketChannel channel : this.sendQueues.keySet()) {
                        channel.keyFor(this.selector).interestOps(4);
                    }
                }
                this.selector.select();
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (key.isAcceptable()) {
                        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
                        SocketChannel socketChannel = serverSocketChannel.accept();
                        socketChannel.socket();
                        socketChannel.configureBlocking(false);
                        socketChannel.register(this.selector, 1);
                        continue;
                    }
                    if (key.isReadable()) {
                        this.read(key);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    this.write(key);
                }
            }
            catch (BufferUnderflowException exception) {
                log.trace("Got a possible corrupt packet", (Throwable)exception);
            }
            catch (Exception exception) {
                log.error("An exception happened processing the RCON server", (Throwable)exception);
            }
        }
        try {
            this.serverChannel.keyFor(this.selector).cancel();
            this.serverChannel.close();
            this.selector.close();
        }
        catch (IOException exception) {
            log.error("An exception happened while closing the RCON server", (Throwable)exception);
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    private void read(SelectionKey key) throws IOException {
        int bytesRead;
        SocketChannel channel = (SocketChannel)key.channel();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            bytesRead = channel.read(buffer);
        }
        catch (IOException exception) {
            key.cancel();
            channel.close();
            this.rconSessions.remove(channel);
            this.sendQueues.remove(channel);
            return;
        }
        if (bytesRead == -1) {
            key.cancel();
            channel.close();
            this.rconSessions.remove(channel);
            this.sendQueues.remove(channel);
            return;
        }
        buffer.flip();
        this.handle(channel, new RCONPacket(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(SocketChannel channel, RCONPacket packet) {
        switch (packet.getType()) {
            case 3: {
                byte[] payload = new byte[1];
                if (new String(packet.getPayload(), Charset.forName("UTF-8")).equals(this.password)) {
                    this.rconSessions.add(channel);
                    this.send(channel, new RCONPacket(packet.getId(), 2, payload));
                    return;
                }
                this.send(channel, new RCONPacket(-1, 2, payload));
                break;
            }
            case 2: {
                if (!this.rconSessions.contains(channel)) {
                    return;
                }
                String command = new String(packet.getPayload(), Charset.forName("UTF-8")).trim();
                List<RCONCommand> list = this.receiveQueue;
                synchronized (list) {
                    this.receiveQueue.add(new RCONCommand(channel, packet.getId(), command));
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey key) throws IOException {
        SocketChannel channel = (SocketChannel)key.channel();
        Map<SocketChannel, List<RCONPacket>> map = this.sendQueues;
        synchronized (map) {
            List<RCONPacket> queue = this.sendQueues.get(channel);
            ByteBuffer buffer = queue.get(0).toBuffer();
            try {
                channel.write(buffer);
                queue.remove(0);
            }
            catch (IOException exception) {
                key.cancel();
                channel.close();
                this.rconSessions.remove(channel);
                this.sendQueues.remove(channel);
                return;
            }
            if (queue.isEmpty()) {
                this.sendQueues.remove(channel);
            }
            key.interestOps(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(SocketChannel channel, RCONPacket packet) {
        if (!channel.keyFor(this.selector).isValid()) {
            return;
        }
        Map<SocketChannel, List<RCONPacket>> map = this.sendQueues;
        synchronized (map) {
            List queue = this.sendQueues.computeIfAbsent(channel, k -> new ArrayList());
            queue.add(packet);
        }
        this.selector.wakeup();
    }
}

