/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.plugin;

import cn.nukkit.plugin.Plugin;
import cn.nukkit.utils.LogLevel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginLogger
implements cn.nukkit.utils.Logger {
    private final String pluginName;
    private final Logger log;

    public PluginLogger(Plugin context) {
        String prefix = context.getDescription().getPrefix();
        this.log = LogManager.getLogger((String)context.getDescription().getMain());
        this.pluginName = prefix != null ? prefix : context.getDescription().getName();
    }

    @Override
    public void emergency(String message) {
        this.log(LogLevel.EMERGENCY, message);
    }

    @Override
    public void alert(String message) {
        this.log(LogLevel.ALERT, message);
    }

    @Override
    public void critical(String message) {
        this.log(LogLevel.CRITICAL, message);
    }

    @Override
    public void error(String message) {
        this.log(LogLevel.ERROR, message);
    }

    @Override
    public void warning(String message) {
        this.log(LogLevel.WARNING, message);
    }

    @Override
    public void notice(String message) {
        this.log(LogLevel.NOTICE, message);
    }

    @Override
    public void info(String message) {
        this.log(LogLevel.INFO, message);
    }

    @Override
    public void debug(String message) {
        this.log(LogLevel.DEBUG, message);
    }

    private Level toApacheLevel(LogLevel level) {
        switch (level) {
            case NONE: {
                return Level.OFF;
            }
            case EMERGENCY: 
            case CRITICAL: {
                return Level.FATAL;
            }
            case ALERT: 
            case WARNING: 
            case NOTICE: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
        }
        return Level.INFO;
    }

    @Override
    public void log(LogLevel level, String message) {
        this.log.log(this.toApacheLevel(level), "[{}]: {}", (Object)this.pluginName, (Object)message);
    }

    @Override
    public void emergency(String message, Throwable t) {
        this.log(LogLevel.EMERGENCY, message, t);
    }

    @Override
    public void alert(String message, Throwable t) {
        this.log(LogLevel.ALERT, message, t);
    }

    @Override
    public void critical(String message, Throwable t) {
        this.log(LogLevel.CRITICAL, message, t);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log(LogLevel.ERROR, message, t);
    }

    @Override
    public void warning(String message, Throwable t) {
        this.log(LogLevel.WARNING, message, t);
    }

    @Override
    public void notice(String message, Throwable t) {
        this.log(LogLevel.NOTICE, message, t);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log(LogLevel.INFO, message, t);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log(LogLevel.DEBUG, message, t);
    }

    @Override
    public void log(LogLevel level, String message, Throwable t) {
        this.log.log(this.toApacheLevel(level), "[{}]: {}", (Object)this.pluginName, (Object)message, (Object)t);
    }
}

