/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.plugin;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.command.PluginCommand;
import cn.nukkit.command.SimpleCommandMap;
import cn.nukkit.event.Event;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.Listener;
import cn.nukkit.lang.BaseLang;
import cn.nukkit.permission.Permissible;
import cn.nukkit.permission.Permission;
import cn.nukkit.plugin.EventExecutor;
import cn.nukkit.plugin.JavaPluginLoader;
import cn.nukkit.plugin.MethodEventExecutor;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginDescription;
import cn.nukkit.plugin.PluginLoader;
import cn.nukkit.plugin.PowerNukkitPlugin;
import cn.nukkit.plugin.RegisteredListener;
import cn.nukkit.utils.PluginException;
import cn.nukkit.utils.Utils;
import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import io.netty.util.internal.EmptyArrays;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginManager {
    @Generated
    private static final Logger log = LogManager.getLogger(PluginManager.class);
    private final Server server;
    private final SimpleCommandMap commandMap;
    protected final Map<String, Plugin> plugins = new LinkedHashMap<String, Plugin>();
    protected final Map<String, Permission> permissions = new HashMap<String, Permission>();
    protected final Map<String, Permission> defaultPerms = new HashMap<String, Permission>();
    protected final Map<String, Permission> defaultPermsOp = new HashMap<String, Permission>();
    protected final Map<String, Set<Permissible>> permSubs = new HashMap<String, Set<Permissible>>();
    protected final Set<Permissible> defSubs = Collections.newSetFromMap(new WeakHashMap());
    protected final Set<Permissible> defSubsOp = Collections.newSetFromMap(new WeakHashMap());
    protected final Map<String, PluginLoader> fileAssociations = new HashMap<String, PluginLoader>();

    public PluginManager(Server server, SimpleCommandMap commandMap) {
        this.server = server;
        this.commandMap = commandMap;
    }

    public Plugin getPlugin(String name) {
        if (this.plugins.containsKey(name)) {
            return this.plugins.get(name);
        }
        return null;
    }

    public boolean registerInterface(Class<? extends PluginLoader> loaderClass) {
        if (loaderClass != null) {
            try {
                Constructor<? extends PluginLoader> constructor = loaderClass.getDeclaredConstructor(Server.class);
                constructor.setAccessible(true);
                this.fileAssociations.put(loaderClass.getName(), constructor.newInstance(this.server));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void loadPowerNukkitPlugins() {
        File file;
        PluginLoader pluginLoader = this.fileAssociations.get(JavaPluginLoader.class.getName());
        PowerNukkitPlugin plugin = PowerNukkitPlugin.getInstance();
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", "PowerNukkit");
        info.put("version", this.server.getNukkitVersion());
        info.put("website", "https://github.com/PowerNukkit/PowerNukkit");
        info.put("main", PowerNukkitPlugin.class.getName());
        try {
            file = new File(Server.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            file = new File(".");
        }
        PluginDescription description = new PluginDescription(info);
        plugin.init(pluginLoader, this.server, description, new File("PowerNukkit"), file);
        this.plugins.put(description.getName(), plugin);
        this.enablePlugin(plugin);
    }

    public Map<String, Plugin> getPlugins() {
        return this.plugins;
    }

    public Plugin loadPlugin(String path) {
        return this.loadPlugin(path, null);
    }

    public Plugin loadPlugin(File file) {
        return this.loadPlugin(file, null);
    }

    public Plugin loadPlugin(String path, Map<String, PluginLoader> loaders) {
        return this.loadPlugin(new File(path), loaders);
    }

    public Plugin loadPlugin(File file, Map<String, PluginLoader> loaders) {
        for (PluginLoader loader : (loaders == null ? this.fileAssociations : loaders).values()) {
            for (Pattern pattern : loader.getPluginFilters()) {
                PluginDescription description;
                if (!pattern.matcher(file.getName()).matches() || (description = loader.getPluginDescription(file)) == null) continue;
                try {
                    Plugin plugin = loader.loadPlugin(file);
                    if (plugin == null) continue;
                    this.plugins.put(plugin.getDescription().getName(), plugin);
                    List<PluginCommand> pluginCommands = this.parseYamlCommands(plugin);
                    if (!pluginCommands.isEmpty()) {
                        this.commandMap.registerAll(plugin.getDescription().getName(), pluginCommands);
                    }
                    return plugin;
                }
                catch (Exception e) {
                    log.fatal("Could not load plugin", (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    public Map<String, Plugin> loadPlugins(String dictionary) {
        return this.loadPlugins(new File(dictionary));
    }

    public Map<String, Plugin> loadPlugins(File dictionary) {
        return this.loadPlugins(dictionary, null);
    }

    public Map<String, Plugin> loadPlugins(String dictionary, List<String> newLoaders) {
        return this.loadPlugins(new File(dictionary), newLoaders);
    }

    public Map<String, Plugin> loadPlugins(File dictionary, List<String> newLoaders) {
        return this.loadPlugins(dictionary, newLoaders, false);
    }

    public Map<String, Plugin> loadPlugins(File dictionary, List<String> newLoaders, boolean includeDir) {
        if (dictionary.isDirectory()) {
            LinkedHashMap<String, File> plugins = new LinkedHashMap<String, File>();
            LinkedHashMap<String, Plugin> loadedPlugins = new LinkedHashMap<String, Plugin>();
            LinkedHashMap<String, List<String>> dependencies = new LinkedHashMap<String, List<String>>();
            LinkedHashMap<String, List<String>> softDependencies = new LinkedHashMap<String, List<String>>();
            Map<Object, Object> loaders = new LinkedHashMap();
            if (newLoaders != null) {
                for (String string : newLoaders) {
                    if (!this.fileAssociations.containsKey(string)) continue;
                    loaders.put(string, this.fileAssociations.get(string));
                }
            } else {
                loaders = this.fileAssociations;
            }
            for (PluginLoader pluginLoader : loaders.values()) {
                for (File file : dictionary.listFiles((dir, name) -> {
                    for (Pattern pattern : loader.getPluginFilters()) {
                        if (!pattern.matcher(name).matches()) continue;
                        return true;
                    }
                    return false;
                })) {
                    if (file.isDirectory() && !includeDir) continue;
                    try {
                        PluginDescription description = pluginLoader.getPluginDescription(file);
                        if (description == null) continue;
                        String name2 = description.getName();
                        if (plugins.containsKey(name2) || this.getPlugin(name2) != null) {
                            log.error(this.server.getLanguage().translateString("nukkit.plugin.duplicateError", name2));
                            continue;
                        }
                        boolean compatible = false;
                        for (String version : description.getCompatibleAPIs()) {
                            try {
                                if (!Pattern.matches("^[0-9]+\\.[0-9]+\\.[0-9]+$", version)) {
                                    throw new IllegalArgumentException("The getCompatibleAPI version don't match the format majorVersion.minorVersion.patch");
                                }
                            }
                            catch (IllegalArgumentException | NullPointerException e) {
                                log.error(this.server.getLanguage().translateString("nukkit.plugin.loadError", new String[]{name2, "Wrong API format"}), (Throwable)e);
                                continue;
                            }
                            String[] versionArray = version.split("\\.");
                            String[] apiVersion = this.server.getApiVersion().split("\\.");
                            if (!Objects.equals(Integer.valueOf(versionArray[0]), Integer.valueOf(apiVersion[0])) || Integer.parseInt(versionArray[1]) > Integer.parseInt(apiVersion[1])) continue;
                            compatible = true;
                            break;
                        }
                        if (!compatible) {
                            log.error(this.server.getLanguage().translateString("nukkit.plugin.loadError", new String[]{name2, "%nukkit.plugin.incompatibleAPI"}));
                        }
                        plugins.put(name2, file);
                        softDependencies.put(name2, description.getSoftDepend());
                        dependencies.put(name2, description.getDepend());
                        for (String before : description.getLoadBefore()) {
                            if (softDependencies.containsKey(before)) {
                                ((List)softDependencies.get(before)).add(name2);
                                continue;
                            }
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(name2);
                            softDependencies.put(before, list);
                        }
                    }
                    catch (Exception e) {
                        log.error(this.server.getLanguage().translateString("nukkit.plugin.fileError", file.getName(), dictionary.toString(), Utils.getExceptionMessage(e)), (Throwable)e);
                    }
                }
            }
            while (!plugins.isEmpty()) {
                boolean missingDependency = true;
                for (String name3 : new ArrayList(plugins.keySet())) {
                    File file = (File)plugins.get(name3);
                    if (dependencies.containsKey(name3)) {
                        for (String dependency2 : new ArrayList((Collection)dependencies.get(name3))) {
                            if (loadedPlugins.containsKey(dependency2) || this.getPlugin(dependency2) != null) {
                                ((List)dependencies.get(name3)).remove(dependency2);
                                continue;
                            }
                            if (plugins.containsKey(dependency2)) continue;
                            BaseLang language = this.server.getLanguage();
                            String cause = language.translateString("nukkit.plugin.missingDependency", dependency2);
                            log.fatal(language.translateString("nukkit.plugin.loadError", new String[]{name3, cause}, (String)null));
                            break;
                        }
                        if (((List)dependencies.get(name3)).isEmpty()) {
                            dependencies.remove(name3);
                        }
                    }
                    if (softDependencies.containsKey(name3)) {
                        ((List)softDependencies.get(name3)).removeIf(dependency -> loadedPlugins.containsKey(dependency) || this.getPlugin((String)dependency) != null);
                        if (((List)softDependencies.get(name3)).isEmpty()) {
                            softDependencies.remove(name3);
                        }
                    }
                    if (dependencies.containsKey(name3) || softDependencies.containsKey(name3)) continue;
                    plugins.remove(name3);
                    missingDependency = false;
                    Plugin plugin = this.loadPlugin(file, loaders);
                    if (plugin != null) {
                        loadedPlugins.put(name3, plugin);
                        continue;
                    }
                    log.fatal(this.server.getLanguage().translateString("nukkit.plugin.genericLoadError", name3));
                }
                if (!missingDependency) continue;
                for (String name2 : new ArrayList(plugins.keySet())) {
                    File file = (File)plugins.get(name2);
                    if (dependencies.containsKey(name2)) continue;
                    softDependencies.remove(name2);
                    plugins.remove(name2);
                    missingDependency = false;
                    Plugin plugin = this.loadPlugin(file, loaders);
                    if (plugin != null) {
                        loadedPlugins.put(name2, plugin);
                        continue;
                    }
                    log.fatal(this.server.getLanguage().translateString("nukkit.plugin.genericLoadError", name2));
                }
                if (!missingDependency) continue;
                for (String name2 : plugins.keySet()) {
                    log.fatal(this.server.getLanguage().translateString("nukkit.plugin.loadError", new String[]{name2, "%nukkit.plugin.circularDependency"}));
                }
                plugins.clear();
            }
            return loadedPlugins;
        }
        return new HashMap<String, Plugin>();
    }

    public Permission getPermission(String name) {
        if (this.permissions.containsKey(name)) {
            return this.permissions.get(name);
        }
        return null;
    }

    public boolean addPermission(Permission permission) {
        if (!this.permissions.containsKey(permission.getName())) {
            this.permissions.put(permission.getName(), permission);
            this.calculatePermissionDefault(permission);
            return true;
        }
        return false;
    }

    public void removePermission(String name) {
        this.permissions.remove(name);
    }

    public void removePermission(Permission permission) {
        this.removePermission(permission.getName());
    }

    public Map<String, Permission> getDefaultPermissions(boolean op) {
        if (op) {
            return this.defaultPermsOp;
        }
        return this.defaultPerms;
    }

    public void recalculatePermissionDefaults(Permission permission) {
        if (this.permissions.containsKey(permission.getName())) {
            this.defaultPermsOp.remove(permission.getName());
            this.defaultPerms.remove(permission.getName());
            this.calculatePermissionDefault(permission);
        }
    }

    private void calculatePermissionDefault(Permission permission) {
        Timings.permissionDefaultTimer.startTiming();
        if (permission.getDefault().equals("op") || permission.getDefault().equals("true")) {
            this.defaultPermsOp.put(permission.getName(), permission);
            this.dirtyPermissibles(true);
        }
        if (permission.getDefault().equals("notop") || permission.getDefault().equals("true")) {
            this.defaultPerms.put(permission.getName(), permission);
            this.dirtyPermissibles(false);
        }
        Timings.permissionDefaultTimer.startTiming();
    }

    private void dirtyPermissibles(boolean op) {
        for (Permissible p : this.getDefaultPermSubscriptions(op)) {
            p.recalculatePermissions();
        }
    }

    public void subscribeToPermission(String permission, Permissible permissible) {
        if (!this.permSubs.containsKey(permission)) {
            this.permSubs.put(permission, Collections.newSetFromMap(new WeakHashMap()));
        }
        this.permSubs.get(permission).add(permissible);
    }

    public void unsubscribeFromPermission(String permission, Permissible permissible) {
        if (this.permSubs.containsKey(permission)) {
            this.permSubs.get(permission).remove(permissible);
            if (this.permSubs.get(permission).size() == 0) {
                this.permSubs.remove(permission);
            }
        }
    }

    public Set<Permissible> getPermissionSubscriptions(String permission) {
        if (this.permSubs.containsKey(permission)) {
            return new HashSet<Permissible>((Collection)this.permSubs.get(permission));
        }
        return new HashSet<Permissible>();
    }

    public void subscribeToDefaultPerms(boolean op, Permissible permissible) {
        if (op) {
            this.defSubsOp.add(permissible);
        } else {
            this.defSubs.add(permissible);
        }
    }

    public void unsubscribeFromDefaultPerms(boolean op, Permissible permissible) {
        if (op) {
            this.defSubsOp.remove(permissible);
        } else {
            this.defSubs.remove(permissible);
        }
    }

    public Set<Permissible> getDefaultPermSubscriptions(boolean op) {
        if (op) {
            return new HashSet<Permissible>(this.defSubsOp);
        }
        return new HashSet<Permissible>(this.defSubs);
    }

    public Map<String, Permission> getPermissions() {
        return this.permissions;
    }

    public boolean isPluginEnabled(Plugin plugin) {
        if (plugin != null && this.plugins.containsKey(plugin.getDescription().getName())) {
            return plugin.isEnabled();
        }
        return false;
    }

    public void enablePlugin(Plugin plugin) {
        if (!plugin.isEnabled()) {
            try {
                for (Permission permission : plugin.getDescription().getPermissions()) {
                    this.addPermission(permission);
                }
                plugin.getPluginLoader().enablePlugin(plugin);
            }
            catch (Throwable e) {
                log.fatal("An error occurred while enabling the plugin {}, {}, {}", (Object)plugin.getDescription().getName(), (Object)plugin.getDescription().getVersion(), (Object)plugin.getDescription().getMain(), (Object)e);
                this.disablePlugin(plugin);
            }
        }
    }

    protected List<PluginCommand> parseYamlCommands(Plugin plugin) {
        ArrayList<PluginCommand> pluginCmds = new ArrayList<PluginCommand>();
        for (Map.Entry<String, Object> entry : plugin.getDescription().getCommands().entrySet()) {
            Object aliases;
            String key = entry.getKey();
            Object data = entry.getValue();
            if (key.contains(":")) {
                log.fatal(this.server.getLanguage().translateString("nukkit.plugin.commandError", new String[]{key, plugin.getDescription().getFullName()}));
                continue;
            }
            if (!(data instanceof Map)) continue;
            PluginCommand<Plugin> newCmd = new PluginCommand<Plugin>(key, plugin);
            if (((Map)data).containsKey("description")) {
                newCmd.setDescription((String)((Map)data).get("description"));
            }
            if (((Map)data).containsKey("usage")) {
                newCmd.setUsage((String)((Map)data).get("usage"));
            }
            if (((Map)data).containsKey("aliases") && (aliases = ((Map)data).get("aliases")) instanceof List) {
                ArrayList<String> aliasList = new ArrayList<String>();
                for (String alias : (List)aliases) {
                    if (alias.contains(":")) {
                        log.fatal(this.server.getLanguage().translateString("nukkit.plugin.aliasError", new String[]{alias, plugin.getDescription().getFullName()}));
                        continue;
                    }
                    aliasList.add(alias);
                }
                newCmd.setAliases(aliasList.toArray(EmptyArrays.EMPTY_STRINGS));
            }
            if (((Map)data).containsKey("permission")) {
                newCmd.setPermission((String)((Map)data).get("permission"));
            }
            if (((Map)data).containsKey("permission-message")) {
                newCmd.setPermissionMessage((String)((Map)data).get("permission-message"));
            }
            pluginCmds.add(newCmd);
        }
        return pluginCmds;
    }

    @PowerNukkitDifference(info="Makes sure the PowerNukkitPlugin is never disabled", since="1.3.0.0-PN")
    public void disablePlugins() {
        ListIterator<Plugin> plugins = new ArrayList<Plugin>(this.getPlugins().values()).listIterator(this.getPlugins().size());
        while (plugins.hasPrevious()) {
            Plugin previous = plugins.previous();
            if (previous == PowerNukkitPlugin.getInstance()) continue;
            this.disablePlugin(previous);
        }
    }

    public void disablePlugin(Plugin plugin) {
        if (PowerNukkitPlugin.getInstance() == plugin) {
            throw new UnsupportedOperationException("The PowerNukkit plugin can't be disabled.");
        }
        if (plugin.isEnabled()) {
            try {
                plugin.getPluginLoader().disablePlugin(plugin);
            }
            catch (Exception e) {
                log.fatal("An error occurred while disabling the plugin {}, {}, {}", (Object)plugin.getDescription().getName(), (Object)plugin.getDescription().getVersion(), (Object)plugin.getDescription().getMain(), (Object)e);
            }
            this.server.getScheduler().cancelTask(plugin);
            HandlerList.unregisterAll(plugin);
            for (Permission permission : plugin.getDescription().getPermissions()) {
                this.removePermission(permission);
            }
        }
    }

    public void clearPlugins() {
        this.disablePlugins();
        this.plugins.clear();
        this.fileAssociations.clear();
        this.permissions.clear();
        this.defaultPerms.clear();
        this.defaultPermsOp.clear();
    }

    public void callEvent(Event event) {
        try {
            for (RegisteredListener registration : this.getEventListeners(event.getClass()).getRegisteredListeners()) {
                if (!registration.getPlugin().isEnabled()) continue;
                try {
                    registration.callEvent(event);
                }
                catch (Exception e) {
                    log.error(this.server.getLanguage().translateString("nukkit.plugin.eventError", event.getEventName(), registration.getPlugin().getDescription().getFullName(), e.getMessage(), registration.getListener().getClass().getName()), (Throwable)e);
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("An error has occurred while calling the event {}", (Object)event, (Object)e);
        }
    }

    public void registerEvents(Listener listener, Plugin plugin) {
        HashSet methods;
        if (!plugin.isEnabled()) {
            throw new PluginException("Plugin attempted to register " + listener.getClass().getName() + " while not enabled");
        }
        HashMap ret = new HashMap();
        try {
            Method[] publicMethods = listener.getClass().getMethods();
            Method[] privateMethods = listener.getClass().getDeclaredMethods();
            methods = new HashSet(publicMethods.length + privateMethods.length, 1.0f);
            Collections.addAll(methods, publicMethods);
            Collections.addAll(methods, privateMethods);
        }
        catch (NoClassDefFoundError e) {
            plugin.getLogger().error("Plugin " + plugin.getDescription().getFullName() + " has failed to register events for " + listener.getClass() + " because " + e.getMessage() + " does not exist.");
            return;
        }
        for (Method method : methods) {
            Class<?> checkClass;
            EventHandler eh = method.getAnnotation(EventHandler.class);
            if (eh == null || method.isBridge() || method.isSynthetic()) continue;
            if (method.getParameterTypes().length != 1 || !Event.class.isAssignableFrom(checkClass = method.getParameterTypes()[0])) {
                plugin.getLogger().error(plugin.getDescription().getFullName() + " attempted to register an invalid EventHandler method signature \"" + method.toGenericString() + "\" in " + listener.getClass());
                continue;
            }
            Class<Event> eventClass = checkClass.asSubclass(Event.class);
            method.setAccessible(true);
            Class<Event> clazz = eventClass;
            while (Event.class.isAssignableFrom(clazz)) {
                if (clazz.getAnnotation(Deprecated.class) != null) {
                    if (!Boolean.parseBoolean(String.valueOf(this.server.getConfig("settings.deprecated-verbpse", true)))) break;
                    log.warn(this.server.getLanguage().translateString("nukkit.plugin.deprecatedEvent", plugin.getName(), clazz.getName(), listener.getClass().getName() + "." + method.getName() + "()"));
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            this.registerEvent(eventClass, listener, eh.priority(), new MethodEventExecutor(method), plugin, eh.ignoreCancelled());
        }
    }

    public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin) throws PluginException {
        this.registerEvent(event, listener, priority, executor, plugin, false);
    }

    public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin, boolean ignoreCancelled) throws PluginException {
        if (!plugin.isEnabled()) {
            throw new PluginException("Plugin attempted to register " + event + " while not enabled");
        }
        try {
            Timing timing = Timings.getPluginEventTiming(event, listener, executor, plugin);
            this.getEventListeners(event).register(new RegisteredListener(listener, executor, priority, plugin, ignoreCancelled, timing));
        }
        catch (IllegalAccessException e) {
            log.error("An error occurred while registering the event listener event:{}, listener:{} for plugin:{} version:{}", event, (Object)listener, (Object)plugin.getDescription().getName(), (Object)plugin.getDescription().getVersion(), (Object)e);
        }
    }

    private HandlerList getEventListeners(Class<? extends Event> type) throws IllegalAccessException {
        try {
            Method method = this.getRegistrationClass(type).getDeclaredMethod("getHandlers", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("getHandlers method in " + type.getName() + " was not static!", e);
        }
        catch (Exception e) {
            IllegalAccessException illegalAccessException = new IllegalAccessException(Utils.getExceptionMessage(e));
            illegalAccessException.addSuppressed(e);
            throw illegalAccessException;
        }
    }

    private Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) throws IllegalAccessException {
        try {
            clazz.getDeclaredMethod("getHandlers", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return this.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlers method required!");
        }
    }
}

