/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.math.MathHelper;
import cn.nukkit.utils.BlockColor;
import java.util.Arrays;

public final class DyeColor
extends Enum<DyeColor> {
    public static final /* enum */ DyeColor BLACK;
    public static final /* enum */ DyeColor RED;
    public static final /* enum */ DyeColor GREEN;
    public static final /* enum */ DyeColor BROWN;
    public static final /* enum */ DyeColor BLUE;
    public static final /* enum */ DyeColor PURPLE;
    public static final /* enum */ DyeColor CYAN;
    public static final /* enum */ DyeColor LIGHT_GRAY;
    public static final /* enum */ DyeColor GRAY;
    public static final /* enum */ DyeColor PINK;
    public static final /* enum */ DyeColor LIME;
    public static final /* enum */ DyeColor YELLOW;
    public static final /* enum */ DyeColor LIGHT_BLUE;
    public static final /* enum */ DyeColor MAGENTA;
    public static final /* enum */ DyeColor ORANGE;
    public static final /* enum */ DyeColor WHITE;
    private int dyeColorMeta;
    private int itemDyeMeta;
    private int woolColorMeta;
    private String colorName;
    private String dyeName;
    private BlockColor blockColor;
    private BlockColor leatherColor;
    private static final DyeColor[] BY_WOOL_DATA;
    private static final DyeColor[] BY_DYE_DATA;
    private static final /* synthetic */ DyeColor[] $VALUES;

    public static DyeColor[] values() {
        return (DyeColor[])$VALUES.clone();
    }

    public static DyeColor valueOf(String name) {
        return Enum.valueOf(DyeColor.class, name);
    }

    private DyeColor(int dyeColorMeta, int woolColorMeta, int itemDyeMeta, String colorName, BlockColor blockColor) {
        this(dyeColorMeta, woolColorMeta, itemDyeMeta, colorName, blockColor, blockColor);
    }

    private DyeColor(int dyeColorMeta, int woolColorMeta, int itemDyeMeta, String colorName, BlockColor blockColor, BlockColor leatherColor) {
        this(dyeColorMeta, woolColorMeta, itemDyeMeta, colorName, colorName + " Dye", blockColor, leatherColor);
    }

    private DyeColor(int dyeColorMeta, int woolColorMeta, int itemDyeMeta, String colorName, String dyeName, BlockColor blockColor) {
        this(dyeColorMeta, woolColorMeta, itemDyeMeta, colorName, blockColor, blockColor);
    }

    private DyeColor(int dyeColorMeta, int woolColorMeta, int itemDyeMeta, String colorName, String dyeName, BlockColor blockColor, BlockColor leatherColor) {
        this.dyeColorMeta = dyeColorMeta;
        this.woolColorMeta = woolColorMeta;
        this.itemDyeMeta = itemDyeMeta;
        this.colorName = colorName;
        this.blockColor = blockColor;
        this.dyeName = dyeName;
        this.leatherColor = leatherColor;
    }

    public BlockColor getColor() {
        return this.blockColor;
    }

    public int getDyeData() {
        return this.dyeColorMeta;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getItemDyeMeta() {
        return this.itemDyeMeta;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockColor getLeatherColor() {
        return this.leatherColor;
    }

    public int getWoolData() {
        return this.woolColorMeta;
    }

    public String getName() {
        return this.colorName;
    }

    public String getDyeName() {
        return this.dyeName;
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="When overflowed, instead of wrapping, the meta will be clamped, accepts the new dye metas")
    public static DyeColor getByDyeData(int dyeColorMeta) {
        return BY_DYE_DATA[MathHelper.clamp(dyeColorMeta, 0, BY_DYE_DATA.length - 1)];
    }

    public static DyeColor getByWoolData(int woolColorMeta) {
        return BY_WOOL_DATA[woolColorMeta & 0xF];
    }

    static {
        int n;
        BLACK = new DyeColor(0, 15, 16, "Black", "Ink Sac", BlockColor.BLACK_BLOCK_COLOR, new BlockColor(0x1D1D21));
        RED = new DyeColor(1, 14, 1, "Red", "Red Dye", BlockColor.RED_BLOCK_COLOR, new BlockColor(11546150));
        GREEN = new DyeColor(2, 13, 2, "Green", "Green Dye", BlockColor.GREEN_BLOCK_COLOR, new BlockColor(6192150));
        BROWN = new DyeColor(3, 12, 17, "Brown", "Cocoa Beans", BlockColor.BROWN_BLOCK_COLOR, new BlockColor(8606770));
        BLUE = new DyeColor(4, 11, 18, "Blue", "Lapis Lazuli", BlockColor.BLUE_BLOCK_COLOR, new BlockColor(3949738));
        PURPLE = new DyeColor(5, 10, 5, "Purple", BlockColor.PURPLE_BLOCK_COLOR, new BlockColor(8991416));
        CYAN = new DyeColor(6, 9, 6, "Cyan", BlockColor.CYAN_BLOCK_COLOR, new BlockColor(1481884));
        LIGHT_GRAY = new DyeColor(7, 8, 7, "Light Gray", BlockColor.LIGHT_GRAY_BLOCK_COLOR, new BlockColor(0x9D9D97));
        GRAY = new DyeColor(8, 7, 8, "Gray", BlockColor.GRAY_BLOCK_COLOR, new BlockColor(4673362));
        PINK = new DyeColor(9, 6, 9, "Pink", BlockColor.PINK_BLOCK_COLOR, new BlockColor(15961002));
        LIME = new DyeColor(10, 5, 10, "Lime", BlockColor.LIME_BLOCK_COLOR, new BlockColor(8439583));
        YELLOW = new DyeColor(11, 4, 11, "Yellow", "Yellow Dye", BlockColor.YELLOW_BLOCK_COLOR, new BlockColor(16701501));
        LIGHT_BLUE = new DyeColor(12, 3, 12, "Light Blue", BlockColor.LIGHT_BLUE_BLOCK_COLOR, new BlockColor(3847130));
        MAGENTA = new DyeColor(13, 2, 13, "Magenta", BlockColor.MAGENTA_BLOCK_COLOR, new BlockColor(13061821));
        ORANGE = new DyeColor(14, 1, 14, "Orange", BlockColor.ORANGE_BLOCK_COLOR, new BlockColor(16750593));
        WHITE = new DyeColor(15, 0, 19, "White", "Bone Meal", BlockColor.WHITE_BLOCK_COLOR, new BlockColor(0xF0F0F0));
        $VALUES = new DyeColor[]{BLACK, RED, GREEN, BROWN, BLUE, PURPLE, CYAN, LIGHT_GRAY, GRAY, PINK, LIME, YELLOW, LIGHT_BLUE, MAGENTA, ORANGE, WHITE};
        BY_WOOL_DATA = DyeColor.values();
        BY_DYE_DATA = new DyeColor[Arrays.stream(BY_WOOL_DATA).mapToInt(DyeColor::getItemDyeMeta).max().orElse(0) + 1];
        DyeColor[] dyeColorArray = BY_WOOL_DATA;
        int n2 = dyeColorArray.length;
        for (n = 0; n < n2; ++n) {
            DyeColor dyeColor;
            DyeColor.BY_DYE_DATA[dyeColor.dyeColorMeta] = dyeColor = dyeColorArray[n];
            DyeColor.BY_DYE_DATA[dyeColor.itemDyeMeta] = dyeColor;
        }
        dyeColorArray = DyeColor.values();
        n2 = dyeColorArray.length;
        for (n = 0; n < n2; ++n) {
            DyeColor color;
            DyeColor.BY_WOOL_DATA[color.woolColorMeta & 0xF] = color = dyeColorArray[n];
        }
    }
}

