/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public interface RedstoneComponent {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public void updateAroundRedstone(BlockFace ... ignoredFaces) {
        if (ignoredFaces == null) {
            ignoredFaces = new BlockFace[]{};
        }
        this.updateAroundRedstone(Arrays.asList(ignoredFaces));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public void updateAroundRedstone(@Nonnull List<BlockFace> ignoredFaces) {
        if (this instanceof Position) {
            RedstoneComponent.updateAroundRedstone((Position)((Object)this), ignoredFaces);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public void updateAllAroundRedstone(BlockFace ... ignoredFaces) {
        if (ignoredFaces == null) {
            ignoredFaces = new BlockFace[]{};
        }
        this.updateAllAroundRedstone(Arrays.asList(ignoredFaces));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public void updateAllAroundRedstone(@Nonnull List<BlockFace> ignoredFaces) {
        if (this instanceof Position) {
            RedstoneComponent.updateAllAroundRedstone((Position)((Object)this), ignoredFaces);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void updateAroundRedstone(@Nonnull Position pos, BlockFace ... ignoredFaces) {
        if (ignoredFaces == null) {
            ignoredFaces = new BlockFace[]{};
        }
        RedstoneComponent.updateAroundRedstone(pos, Arrays.asList(ignoredFaces));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void updateAroundRedstone(@Nonnull Position pos, @Nonnull List<BlockFace> ignoredFaces) {
        for (BlockFace face : BlockFace.values()) {
            if (ignoredFaces.contains((Object)face)) continue;
            pos.getLevelBlock().getSide(face).onUpdate(6);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void updateAllAroundRedstone(@Nonnull Position pos, BlockFace ... ignoredFaces) {
        if (ignoredFaces == null) {
            ignoredFaces = new BlockFace[]{};
        }
        RedstoneComponent.updateAllAroundRedstone(pos, Arrays.asList(ignoredFaces));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void updateAllAroundRedstone(@Nonnull Position pos, @Nonnull List<BlockFace> ignoredFaces) {
        RedstoneComponent.updateAroundRedstone(pos, ignoredFaces);
        for (BlockFace face : BlockFace.values()) {
            if (ignoredFaces.contains((Object)face)) continue;
            RedstoneComponent.updateAroundRedstone(pos.getSide(face), face.getOpposite());
        }
    }
}

