/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils.collection;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.utils.collection.ConvertingSetWrapper;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class ConvertingMapWrapper<K, V1, V2>
extends AbstractMap<K, V1> {
    private final Function<V1, V2> converter;
    private final Function<V2, V1> reverseConverter;
    private final Map<K, V2> proxied;
    private final ConvertingSetWrapper<Map.Entry<K, V1>, Map.Entry<K, V2>> entrySet;
    private final boolean convertReturnedNulls;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ConvertingMapWrapper(Map<K, V2> proxied, Function<V1, V2> converter, Function<V2, V1> reverseConverter, boolean convertReturnedNulls) {
        this.proxied = proxied;
        this.converter = converter;
        this.reverseConverter = reverseConverter;
        this.convertReturnedNulls = convertReturnedNulls;
        this.entrySet = new ConvertingSetWrapper<Map.Entry, Map.Entry>(proxied.entrySet(), entry -> new EntryWrapper(entry, reverseConverter, converter), entry -> new EntryWrapper(entry, converter, reverseConverter));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ConvertingMapWrapper(Map<K, V2> proxied, Function<V1, V2> converter, Function<V2, V1> reverseConverter) {
        this(proxied, converter, reverseConverter, false);
    }

    @Override
    public Set<Map.Entry<K, V1>> entrySet() {
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.proxied.size();
    }

    @Override
    public boolean isEmpty() {
        return this.proxied.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        Function<V1, V2> uncheckedConverter = this.converter;
        V2 converted = uncheckedConverter.apply(value);
        return this.proxied.containsValue(converted);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.proxied.containsKey(key);
    }

    @Override
    public V1 get(Object key) {
        V2 found = this.proxied.get(key);
        if (found == null && !this.convertReturnedNulls) {
            return null;
        }
        return this.reverseConverter.apply(found);
    }

    @Override
    public V1 put(K key, V1 value) {
        V2 removed = this.proxied.put(key, this.converter.apply(value));
        if (removed == null && !this.convertReturnedNulls) {
            return null;
        }
        return this.reverseConverter.apply(removed);
    }

    @Override
    public V1 remove(Object key) {
        V2 removed = this.proxied.remove(key);
        if (removed == null && !this.convertReturnedNulls) {
            return null;
        }
        return this.reverseConverter.apply(removed);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Function<V1, V2> uncheckedConverter = this.converter;
        V2 converted = uncheckedConverter.apply(value);
        return this.proxied.remove(key, converted);
    }

    @Override
    public void clear() {
        this.proxied.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.proxied.keySet();
    }

    private class EntryWrapper<E1, E2>
    implements Map.Entry<K, E1> {
        private final Function<E1, E2> entryConverter;
        private final Function<E2, E1> entryReverseConverter;
        private final Map.Entry<K, E2> entryProxied;

        public EntryWrapper(Map.Entry<K, E2> entryProxied, Function<E1, E2> entryConverter, Function<E2, E1> entryReverseConverter) {
            this.entryConverter = entryConverter;
            this.entryReverseConverter = entryReverseConverter;
            this.entryProxied = entryProxied;
        }

        @Override
        public K getKey() {
            return this.entryProxied.getKey();
        }

        @Override
        public E1 getValue() {
            E2 value = this.entryProxied.getValue();
            if (value == null && !ConvertingMapWrapper.this.convertReturnedNulls) {
                return null;
            }
            return this.entryReverseConverter.apply(value);
        }

        @Override
        public E1 setValue(E1 value) {
            E2 newValue = this.entryConverter.apply(value);
            E2 oldValue = this.entryProxied.setValue(newValue);
            if (oldValue == null && !ConvertingMapWrapper.this.convertReturnedNulls) {
                return null;
            }
            return this.entryReverseConverter.apply(oldValue);
        }

        public String toString() {
            return this.entryProxied.getKey() + "=" + this.getValue();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.entryProxied.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.entryProxied.getKey()) ^ Objects.hashCode(this.getValue());
        }
    }
}

