/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityCauldron;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityCombustByBlockEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.player.PlayerBucketEmptyEvent;
import cn.nukkit.event.player.PlayerBucketFillEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.item.MinecraftItemID;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.Vector3;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockCauldronLava
extends BlockCauldron {
    @PowerNukkitOnly
    public BlockCauldronLava() {
        this(8);
    }

    @PowerNukkitOnly
    public BlockCauldronLava(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Lava Cauldron";
    }

    @Override
    public int getId() {
        return 465;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return this.shrink(0.3, 0.3, 0.3);
    }

    @Override
    @PowerNukkitOnly
    public void setFillLevel(int fillLevel) {
        super.setFillLevel(fillLevel);
        this.setDamage(this.getDamage() | 8);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        EntityCombustByBlockEvent ev = new EntityCombustByBlockEvent(this, entity, 15);
        Server.getInstance().getPluginManager().callEvent(ev);
        if (!ev.isCancelled() && entity.isAlive() && entity.noDamageTicks == 0) {
            entity.setOnFire(ev.getDuration());
        }
        if (!entity.hasEffect(12)) {
            entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.LAVA, 4.0f));
        }
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        BlockEntity be = this.level.getBlockEntity(this);
        if (!(be instanceof BlockEntityCauldron)) {
            return false;
        }
        BlockEntityCauldron cauldron = (BlockEntityCauldron)be;
        switch (item.getId()) {
            case 325: {
                ItemBucket bucket = (ItemBucket)item;
                if (bucket.getFishEntityId() != null) break;
                if (item.getDamage() == 0) {
                    if (!this.isFull() || cauldron.isCustomColor() || cauldron.hasPotion()) break;
                    PlayerBucketFillEvent ev = new PlayerBucketFillEvent(player, this, null, this, item, MinecraftItemID.LAVA_BUCKET.get(1, bucket.getCompoundTag()));
                    this.level.getServer().getPluginManager().callEvent(ev);
                    if (ev.isCancelled()) break;
                    this.replaceBucket(bucket, player, ev.getItem());
                    this.setFillLevel(FILL_LEVEL.getMinValue());
                    this.level.setBlock((Vector3)this, new BlockCauldron(0), true);
                    cauldron.clearCustomColor();
                    this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.BUCKET_FILL_LAVA);
                    break;
                }
                if (!bucket.isWater() && !bucket.isLava() || this.isFull() && !cauldron.isCustomColor() && !cauldron.hasPotion() && item.getDamage() == 10) break;
                PlayerBucketEmptyEvent ev = new PlayerBucketEmptyEvent(player, this, null, this, item, MinecraftItemID.BUCKET.get(1, bucket.getCompoundTag()));
                this.level.getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) break;
                this.replaceBucket(bucket, player, ev.getItem());
                if (cauldron.hasPotion()) {
                    this.clearWithFizz(cauldron);
                    break;
                }
                if (bucket.isLava()) {
                    this.setFillLevel(FILL_LEVEL.getMaxValue());
                    cauldron.clearCustomColor();
                    this.level.setBlock((Vector3)this, this, true);
                    this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.BUCKET_EMPTY_LAVA);
                    break;
                }
                if (this.isEmpty()) {
                    this.level.setBlock((Vector3)this, new BlockCauldron(6), true, true);
                    cauldron.clearCustomColor();
                    this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.CAULDRON_FILLWATER);
                    break;
                }
                this.clearWithFizz(cauldron);
                break;
            }
            case 373: 
            case 438: 
            case 441: {
                if (!this.isEmpty() && (cauldron.hasPotion() ? cauldron.getPotionId() != item.getDamage() : item.getDamage() != 0)) {
                    this.clearWithFizz(cauldron);
                    break;
                }
                return super.onActivate(item, player);
            }
            case 374: {
                if (!this.isEmpty() && cauldron.hasPotion()) {
                    return super.onActivate(item, player);
                }
            }
            default: {
                return true;
            }
        }
        this.level.updateComparatorOutputLevel(this);
        return true;
    }
}

