/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemString;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockCobweb
extends BlockFlowable {
    public BlockCobweb() {
        this(0);
    }

    public BlockCobweb(int meta) {
        super(0);
    }

    @Override
    public String getName() {
        return "Cobweb";
    }

    @Override
    public int getId() {
        return 30;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return CommonBlockProperties.EMPTY_PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 4.0;
    }

    @Override
    public double getResistance() {
        return 20.0;
    }

    @Override
    public int getToolType() {
        return 1;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.resetFallDistance();
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        if (item.isSword()) {
            return new Item[]{new ItemString()};
        }
        return Item.EMPTY_ARRAY;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.CLOTH_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    @PowerNukkitOnly
    public boolean diffusesSkyLight() {
        return true;
    }
}

