/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.MinecraftItemID;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockCocoa
extends BlockTransparentMeta
implements Faceable {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final IntBlockProperty AGE = new IntBlockProperty("age", false, 2);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, AGE);
    protected static final AxisAlignedBB[] EAST = new SimpleAxisAlignedBB[]{new SimpleAxisAlignedBB(0.6875, 0.4375, 0.375, 0.9375, 0.75, 0.625), new SimpleAxisAlignedBB(0.5625, 0.3125, 0.3125, 0.9375, 0.75, 0.6875), new SimpleAxisAlignedBB(0.5625, 0.3125, 0.3125, 0.9375, 0.75, 0.6875)};
    protected static final AxisAlignedBB[] WEST = new SimpleAxisAlignedBB[]{new SimpleAxisAlignedBB(0.0625, 0.4375, 0.375, 0.3125, 0.75, 0.625), new SimpleAxisAlignedBB(0.0625, 0.3125, 0.3125, 0.4375, 0.75, 0.6875), new SimpleAxisAlignedBB(0.0625, 0.3125, 0.3125, 0.4375, 0.75, 0.6875)};
    protected static final AxisAlignedBB[] NORTH = new SimpleAxisAlignedBB[]{new SimpleAxisAlignedBB(0.375, 0.4375, 0.0625, 0.625, 0.75, 0.3125), new SimpleAxisAlignedBB(0.3125, 0.3125, 0.0625, 0.6875, 0.75, 0.4375), new SimpleAxisAlignedBB(0.3125, 0.3125, 0.0625, 0.6875, 0.75, 0.4375)};
    protected static final AxisAlignedBB[] SOUTH = new SimpleAxisAlignedBB[]{new SimpleAxisAlignedBB(0.375, 0.4375, 0.6875, 0.625, 0.75, 0.9375), new SimpleAxisAlignedBB(0.3125, 0.3125, 0.5625, 0.6875, 0.75, 0.9375), new SimpleAxisAlignedBB(0.3125, 0.3125, 0.5625, 0.6875, 0.75, 0.9375)};
    protected static final AxisAlignedBB[] ALL = new AxisAlignedBB[12];

    public BlockCocoa() {
        this(0);
    }

    public BlockCocoa(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 127;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Cocoa";
    }

    @Override
    public double getMinX() {
        return this.x + this.getRelativeBoundingBox().getMinX();
    }

    @Override
    public double getMaxX() {
        return this.x + this.getRelativeBoundingBox().getMaxX();
    }

    @Override
    public double getMinY() {
        return this.y + this.getRelativeBoundingBox().getMinY();
    }

    @Override
    public double getMaxY() {
        return this.y + this.getRelativeBoundingBox().getMaxY();
    }

    @Override
    public double getMinZ() {
        return this.z + this.getRelativeBoundingBox().getMinZ();
    }

    @Override
    public double getMaxZ() {
        return this.z + this.getRelativeBoundingBox().getMaxZ();
    }

    private AxisAlignedBB getRelativeBoundingBox() {
        AxisAlignedBB[] bbs;
        AxisAlignedBB boundingBox;
        int damage = this.getDamage();
        if (damage > 11) {
            damage = 11;
            this.setDamage(11);
        }
        if ((boundingBox = ALL[damage]) != null) {
            return boundingBox;
        }
        switch (this.getDamage()) {
            case 1: 
            case 5: 
            case 9: {
                bbs = EAST;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                bbs = SOUTH;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                bbs = WEST;
                break;
            }
            default: {
                bbs = NORTH;
            }
        }
        BlockCocoa.ALL[damage] = bbs[this.getDamage() >> 2];
        return BlockCocoa.ALL[damage];
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (target.getId() == 17 && (target.getDamage() & 3) == 3 && face != BlockFace.DOWN && face != BlockFace.UP) {
            int[] faces = new int[]{0, 0, 0, 2, 3, 1};
            this.setDamage(faces[face.getIndex()]);
            this.level.setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            int[] faces = new int[]{3, 4, 2, 5, 3, 4, 2, 5, 3, 4, 2, 5};
            Block side = this.getSide(BlockFace.fromIndex(faces[this.getDamage()]));
            if (side.getId() != 17 && side.getDamage() != 3) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        } else if (type == 2) {
            if (ThreadLocalRandom.current().nextInt(2) == 1) {
                if (this.getGrowthStage() < 2 && !this.grow()) {
                    return 2;
                }
            } else {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isFertilizer()) {
            if (this.getGrowthStage() < 2) {
                if (!this.grow()) {
                    return false;
                }
                this.level.addParticle(new BoneMealParticle(this));
                if (player != null && (player.gamemode & 1) == 0) {
                    --item.count;
                }
            }
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    public int getGrowthStage() {
        return this.getDamage() / 4;
    }

    @PowerNukkitOnly
    public boolean grow() {
        Block block = this.clone();
        block.setDamage(block.getDamage() + 4);
        BlockGrowEvent ev = new BlockGrowEvent(this, block);
        Server.getInstance().getPluginManager().callEvent(ev);
        return !ev.isCancelled() && this.getLevel().setBlock((Vector3)this, ev.getNewState(), true, true);
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public Item toItem() {
        return MinecraftItemID.COCOA_BEANS.get(1);
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{MinecraftItemID.COCOA_BEANS.get(this.getDamage() >= 8 ? 3 : 1)};
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    @PowerNukkitOnly
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public boolean sticksToPiston() {
        return false;
    }
}

