/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockCoralFan;
import cn.nukkit.block.BlockCoralFanDead;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.value.CoralType;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.Faceable;
import java.io.Serializable;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockCoralFanHang
extends BlockCoralFan
implements Faceable {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final ArrayBlockProperty<CoralType> HANG1_TYPE = new ArrayBlockProperty("coral_hang_type_bit", true, (Serializable[])new CoralType[]{CoralType.BLUE, CoralType.PINK}).ordinal(true);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final ArrayBlockProperty<BlockFace> HANG_DIRECTION = new ArrayBlockProperty("coral_direction", false, (Serializable[])new BlockFace[]{BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH}).ordinal(true);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(HANG1_TYPE, CommonBlockProperties.PERMANENTLY_DEAD, HANG_DIRECTION);

    @PowerNukkitOnly
    public BlockCoralFanHang() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockCoralFanHang(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 390;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        String name = super.getName();
        name = name.substring(0, name.length() - 4);
        if (this.isDead()) {
            return "Dead " + name + " Wall Fan";
        }
        return name + " Wall Fan";
    }

    @Override
    @PowerNukkitOnly
    public boolean isDead() {
        return (this.getDamage() & 2) == 2;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            return type;
        }
        return super.onUpdate(type);
    }

    @Override
    @PowerNukkitOnly
    public int getType() {
        if ((this.getDamage() & 1) == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public BlockFace getBlockFace() {
        int face = this.getDamage() >> 2 & 3;
        switch (face) {
            case 0: {
                return BlockFace.WEST;
            }
            case 1: {
                return BlockFace.EAST;
            }
            case 2: {
                return BlockFace.NORTH;
            }
        }
        return BlockFace.SOUTH;
    }

    @Override
    @PowerNukkitOnly
    public BlockFace getRootsFace() {
        return this.getBlockFace().getOpposite();
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this.isDead() ? new BlockCoralFanDead() : new BlockCoralFan(), (Integer)this.getType());
    }
}

