/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockConnectable;
import cn.nukkit.block.BlockFenceGate;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockTrapdoor;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.value.WoodType;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.VectorMath;
import cn.nukkit.utils.BlockColor;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(info="Implements BlockConnectable only on PowerNukkit", since="1.3.0.0-PN")
public class BlockFence
extends BlockTransparentMeta
implements BlockConnectable {
    @PowerNukkitOnly
    public static final BlockProperties PROPERTIES = new BlockProperties(WoodType.PROPERTY);
    @Deprecated
    @DeprecationDetails(reason="Moved to the block property system", since="1.4.0.0-PN", replaceWith="getWoodType()")
    public static final int FENCE_OAK = 0;
    @Deprecated
    @DeprecationDetails(reason="Moved to the block property system", since="1.4.0.0-PN", replaceWith="getWoodType()")
    public static final int FENCE_SPRUCE = 1;
    @Deprecated
    @DeprecationDetails(reason="Moved to the block property system", since="1.4.0.0-PN", replaceWith="getWoodType()")
    public static final int FENCE_BIRCH = 2;
    @Deprecated
    @DeprecationDetails(reason="Moved to the block property system", since="1.4.0.0-PN", replaceWith="getWoodType()")
    public static final int FENCE_JUNGLE = 3;
    @Deprecated
    @DeprecationDetails(reason="Moved to the block property system", since="1.4.0.0-PN", replaceWith="getWoodType()")
    public static final int FENCE_ACACIA = 4;
    @Deprecated
    @DeprecationDetails(reason="Moved to the block property system", since="1.4.0.0-PN", replaceWith="getWoodType()")
    public static final int FENCE_DARK_OAK = 5;

    public BlockFence() {
        this(0);
    }

    public BlockFence(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 85;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setWoodType(@Nullable WoodType woodType) {
        this.setPropertyValue(WoodType.PROPERTY, woodType);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Optional<WoodType> getWoodType() {
        return Optional.of(this.getPropertyValue(WoodType.PROPERTY));
    }

    @Override
    public String getName() {
        return this.getPropertyValue(WoodType.PROPERTY).getEnglishName() + " Fence";
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        boolean north = this.canConnect(this.north());
        boolean south = this.canConnect(this.south());
        boolean west = this.canConnect(this.west());
        boolean east = this.canConnect(this.east());
        double n = north ? 0.0 : 0.375;
        double s = south ? 1.0 : 0.625;
        double w = west ? 0.0 : 0.375;
        double e = east ? 1.0 : 0.625;
        return new SimpleAxisAlignedBB(this.x + w, this.y, this.z + n, this.x + e, this.y + 1.5, this.z + s);
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 20;
    }

    @Override
    public boolean canConnect(Block block) {
        if (block instanceof BlockFence) {
            if (block.getId() == 113 || this.getId() == 113) {
                return block.getId() == this.getId();
            }
            return true;
        }
        if (block instanceof BlockTrapdoor) {
            BlockTrapdoor trapdoor = (BlockTrapdoor)block;
            return trapdoor.isOpen() && trapdoor.getBlockFace() == VectorMath.calculateFace(this, trapdoor);
        }
        return block instanceof BlockFenceGate || block.isSolid() && !block.isTransparent();
    }

    @Override
    public BlockColor getColor() {
        return this.getPropertyValue(WoodType.PROPERTY).getColor();
    }
}

