/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockFence;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import cn.nukkit.blockproperty.value.WoodType;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public abstract class BlockFenceBase
extends BlockFence {
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockFenceBase() {
        this(0);
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockFenceBase(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return CommonBlockProperties.EMPTY_PROPERTIES;
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="Will always returns empty on this type. It is here for backward compatibility", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public Optional<WoodType> getWoodType() {
        return Optional.empty();
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="Only accepts null. It is here for backward compatibility", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setWoodType(@Nullable WoodType woodType) {
        if (woodType != null) {
            throw new InvalidBlockPropertyValueException(WoodType.PROPERTY, null, (Serializable)((Object)woodType), "This block don't have a regular wood type");
        }
    }
}

