/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWall;
import cn.nukkit.blockentity.BlockEntityItemFrame;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemItemFrame;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.Faceable;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder and Faceable only in PowerNukkit")
public class BlockItemFrame
extends BlockTransparentMeta
implements BlockEntityHolder<BlockEntityItemFrame>,
Faceable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty HAS_MAP = new BooleanBlockProperty("item_frame_map_bit", false);
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public static final BooleanBlockProperty HAS_PHOTO = new BooleanBlockProperty("item_frame_photo_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.FACING_DIRECTION, HAS_MAP, HAS_PHOTO);

    public BlockItemFrame() {
        this(0);
    }

    public BlockItemFrame(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 199;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.FACING_DIRECTION);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockFace(@Nonnull BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.FACING_DIRECTION, face);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isStoringMap() {
        return this.getBooleanValue(HAS_MAP);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setStoringMap(boolean map) {
        this.setBooleanValue(HAS_MAP, map);
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public boolean isStoringPhoto() {
        return this.getBooleanValue(HAS_PHOTO);
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setStoringPhoto(boolean hasPhoto) {
        this.setBooleanValue(HAS_PHOTO, hasPhoto);
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "ItemFrame";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityItemFrame> getBlockEntityClass() {
        return BlockEntityItemFrame.class;
    }

    @Override
    public String getName() {
        return "Item Frame";
    }

    @Override
    @PowerNukkitDifference(info="Allow to stay in walls", since="1.3.0.0-PN")
    public int onUpdate(int type) {
        Block support;
        if (type == 1 && !(support = this.getSideAtLayer(0, this.getFacing().getOpposite())).isSolid() && support.getId() != 139) {
            this.level.useBreakOn(this);
            return type;
        }
        return 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int onTouch(@Nullable Player player, PlayerInteractEvent.Action action) {
        if (action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (player == null || !player.isCreative() && !player.isSpectator())) {
            ((BlockEntityItemFrame)this.getOrCreateBlockEntity()).dropItem(player);
        }
        return super.onTouch(player, action);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        BlockEntityItemFrame itemFrame = (BlockEntityItemFrame)this.getOrCreateBlockEntity();
        if (itemFrame.getItem().isNull()) {
            Item itemOnFrame = item.clone();
            if (player != null && !player.isCreative()) {
                itemOnFrame.setCount(itemOnFrame.getCount() - 1);
                player.getInventory().setItemInHand(itemOnFrame);
            }
            itemOnFrame.setCount(1);
            itemFrame.setItem(itemOnFrame);
            if (itemOnFrame.getId() == 358) {
                this.setStoringMap(true);
                this.getLevel().setBlock((Vector3)this, this, true);
            }
            this.getLevel().addLevelEvent(this, 1040);
        } else {
            itemFrame.setItemRotation((itemFrame.getItemRotation() + 1) % 8);
            if (this.isStoringMap()) {
                this.setStoringMap(false);
                this.getLevel().setBlock((Vector3)this, this, true);
            }
            this.getLevel().addLevelEvent(this, 1044);
        }
        return true;
    }

    @Override
    @PowerNukkitDifference(info="Allow to place on walls", since="1.3.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        BlockEntityItemFrame frame;
        if (!target.isSolid() && !(target instanceof BlockWall) && !target.equals(block) || block.isSolid() && !block.canBeReplaced()) {
            return false;
        }
        if (target.equals(block) && block.canBeReplaced()) {
            face = BlockFace.UP;
            target = block.down();
            if (!target.isSolid() && !(target instanceof BlockWall)) {
                return false;
            }
        }
        this.setBlockFace(face);
        this.setStoringMap(item.getId() == 358);
        CompoundTag nbt = new CompoundTag().putByte("ItemRotation", 0).putFloat("ItemDropChance", 1.0f);
        if (item.hasCustomBlockData()) {
            for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                nbt.put(aTag.getName(), aTag);
            }
        }
        if ((frame = (BlockEntityItemFrame)BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt, new Object[0])) == null) {
            return false;
        }
        this.getLevel().addSound(this, Sound.BLOCK_ITEMFRAME_PLACE);
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        this.getLevel().setBlock(this, this.layer, Block.get(0), true, true);
        this.getLevel().addLevelEvent(this, 1042);
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        BlockEntityItemFrame itemFrame = (BlockEntityItemFrame)this.getBlockEntity();
        if (itemFrame != null && ThreadLocalRandom.current().nextFloat() <= itemFrame.getItemDropChance()) {
            return new Item[]{this.toItem(), itemFrame.getItem().clone()};
        }
        return new Item[]{this.toItem()};
    }

    @Override
    public Item toItem() {
        return new ItemItemFrame();
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntityItemFrame blockEntity = (BlockEntityItemFrame)this.getBlockEntity();
        if (blockEntity != null) {
            return blockEntity.getAnalogOutput();
        }
        return super.getComparatorInputOverride();
    }

    public BlockFace getFacing() {
        return this.getBlockFace();
    }

    @Override
    public double getHardness() {
        return 0.25;
    }

    @Override
    @PowerNukkitOnly
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public boolean sticksToPiston() {
        return false;
    }

    @Override
    @PowerNukkitDifference(since="1.3.0.0-PN", info="Will calculate the correct AABB")
    protected AxisAlignedBB recalculateBoundingBox() {
        double[][] aabb = new double[][]{{0.125, 0.875}, {0.125, 0.875}, {0.125, 0.875}};
        BlockFace facing = this.getFacing();
        if (facing.getAxisDirection() == BlockFace.AxisDirection.POSITIVE) {
            int axis = facing.getAxis().ordinal();
            aabb[axis][0] = 0.0;
            aabb[axis][1] = 0.0625;
        }
        return new SimpleAxisAlignedBB(aabb[0][0] + this.x, aabb[1][0] + this.y, aabb[2][0] + this.z, aabb[0][1] + this.x, aabb[1][1] + this.y, aabb[2][1] + this.z);
    }
}

