/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockPistonBase;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntityPistonArm;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;
import javax.annotation.Nonnull;

public class BlockPistonHead
extends BlockTransparentMeta
implements Faceable {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = BlockPistonBase.PROPERTIES;

    public BlockPistonHead() {
        this(0);
    }

    public BlockPistonHead(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 34;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Piston Head";
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public Item[] getDrops(Item item) {
        return Item.EMPTY_ARRAY;
    }

    @Override
    @PowerNukkitDifference(info="Remove BlockEntity of piston on break.", since="1.4.0.0-PN")
    public boolean onBreak(Item item) {
        this.level.setBlock((Vector3)this, Block.get(0), true, true);
        Block side = this.getSide(this.getBlockFace().getOpposite());
        if (side instanceof BlockPistonBase && ((BlockPistonBase)side).getBlockFace() == this.getBlockFace()) {
            BlockPistonBase piston = (BlockPistonBase)side;
            piston.onBreak(item);
            if (piston.getBlockEntity() != null) {
                ((BlockEntityPistonArm)piston.getBlockEntity()).close();
            }
        }
        return true;
    }

    @Since(value="1.6.0.0-PN")
    public BlockFace getFacing() {
        return this.getBlockFace();
    }

    @Override
    @PowerNukkitOnly
    public BlockFace getBlockFace() {
        BlockFace face = BlockFace.fromIndex(this.getDamage());
        return face.getHorizontalIndex() >= 0 ? face.getOpposite() : face;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    @PowerNukkitOnly
    public boolean canBePulled() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(Block.get(0));
    }
}

