/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockRail;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.OptionalBoolean;
import cn.nukkit.utils.Rail;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN")
public class BlockRailActivator
extends BlockRail
implements RedstoneComponent {
    public BlockRailActivator(int meta) {
        super(meta);
    }

    public BlockRailActivator() {
        this(0);
        this.canBePowered = true;
    }

    @Override
    public String getName() {
        return "Activator Rail";
    }

    @Override
    public int getId() {
        return 126;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return ACTIVABLE_PROPERTIES;
    }

    @Override
    @PowerNukkitDifference(info="Using new method for checking if powered", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type == 1 || type == 6 || type == 3) {
            super.onUpdate(type);
            boolean wasPowered = this.isActive();
            boolean isPowered = this.isGettingPower() || this.checkSurrounding(this, true, 0) || this.checkSurrounding(this, false, 0);
            boolean hasUpdate = false;
            if (wasPowered != isPowered) {
                this.setActive(isPowered);
                hasUpdate = true;
            }
            if (hasUpdate) {
                this.level.updateAround(this.down());
                if (this.getOrientation().isAscending()) {
                    this.level.updateAround(this.up());
                }
            }
            return type;
        }
        return 0;
    }

    protected boolean checkSurrounding(Vector3 pos, boolean relative, int power) {
        int dz;
        int dy;
        if (power >= 8) {
            return false;
        }
        int dx = pos.getFloorX();
        Block block2 = this.level.getBlock(new Vector3(dx, dy = pos.getFloorY(), dz = pos.getFloorZ()));
        if (!Rail.isRailBlock(block2)) {
            return false;
        }
        BlockRail block = (BlockRail)block2;
        Rail.Orientation base = null;
        boolean onStraight = true;
        switch (block.getOrientation()) {
            case STRAIGHT_NORTH_SOUTH: {
                if (relative) {
                    ++dz;
                    break;
                }
                --dz;
                break;
            }
            case STRAIGHT_EAST_WEST: {
                if (relative) {
                    --dx;
                    break;
                }
                ++dx;
                break;
            }
            case ASCENDING_EAST: {
                if (relative) {
                    --dx;
                } else {
                    ++dx;
                    ++dy;
                    onStraight = false;
                }
                base = Rail.Orientation.STRAIGHT_EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (relative) {
                    --dx;
                    ++dy;
                    onStraight = false;
                } else {
                    ++dx;
                }
                base = Rail.Orientation.STRAIGHT_EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (relative) {
                    ++dz;
                } else {
                    --dz;
                    ++dy;
                    onStraight = false;
                }
                base = Rail.Orientation.STRAIGHT_NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (relative) {
                    ++dz;
                    ++dy;
                    onStraight = false;
                } else {
                    --dz;
                }
                base = Rail.Orientation.STRAIGHT_NORTH_SOUTH;
                break;
            }
            default: {
                return false;
            }
        }
        return this.canPowered(new Vector3(dx, dy, dz), base, power, relative) || onStraight && this.canPowered(new Vector3(dx, (double)dy - 1.0, dz), base, power, relative);
    }

    @PowerNukkitDifference(info="Using new method for checking if powered", since="1.4.0.0-PN")
    protected boolean canPowered(Vector3 pos, Rail.Orientation state, int power, boolean relative) {
        Block block = this.level.getBlock(pos);
        if (!(block instanceof BlockRailActivator)) {
            return false;
        }
        Rail.Orientation base = ((BlockRailActivator)block).getOrientation();
        return (state != Rail.Orientation.STRAIGHT_EAST_WEST || base != Rail.Orientation.STRAIGHT_NORTH_SOUTH && base != Rail.Orientation.ASCENDING_NORTH && base != Rail.Orientation.ASCENDING_SOUTH) && (state != Rail.Orientation.STRAIGHT_NORTH_SOUTH || base != Rail.Orientation.STRAIGHT_EAST_WEST && base != Rail.Orientation.ASCENDING_EAST && base != Rail.Orientation.ASCENDING_WEST) && (this.isGettingPower() || this.checkSurrounding(pos, relative, power + 1));
    }

    @Override
    public boolean isActive() {
        return this.getBooleanValue(ACTIVE);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public OptionalBoolean isRailActive() {
        return OptionalBoolean.of(this.getBooleanValue(ACTIVE));
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setRailActive(boolean active) {
        this.setBooleanValue(ACTIVE, active);
    }
}

