/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLever;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Implements RedstoneComponent and uses methods from it.", since="1.4.0.0-PN")
public abstract class BlockRedstoneDiode
extends BlockFlowable
implements RedstoneComponent,
Faceable {
    protected boolean isPowered = false;

    public BlockRedstoneDiode() {
        this(0);
    }

    public BlockRedstoneDiode(int meta) {
        super(meta);
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        Location pos = this.getLocation();
        this.level.setBlock((Vector3)this, Block.get(0), true, true);
        if (this.level.getServer().isRedstoneEnabled()) {
            this.updateAllAroundRedstone(new BlockFace[0]);
        }
        return true;
    }

    @Override
    @PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="Allow to be placed on top of the walls", since="1.3.0.0-PN"), @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")})
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (!this.isSupportValid(this.down())) {
            return false;
        }
        this.setDamage(player != null ? player.getDirection().getOpposite().getHorizontalIndex() : 0);
        if (!this.level.setBlock((Vector3)block, this, true, true)) {
            return false;
        }
        if (this.level.getServer().isRedstoneEnabled() && this.shouldBePowered()) {
            this.level.scheduleUpdate(this, 1);
        }
        return true;
    }

    @PowerNukkitOnly
    protected boolean isSupportValid(Block support) {
        return BlockLever.isSupportValid(support, BlockFace.UP) || support instanceof BlockCauldron;
    }

    @Override
    @PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="Allow to be placed on top of the walls", since="1.3.0.0-PN"), @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")})
    public int onUpdate(int type) {
        if (type == 3) {
            if (!this.level.getServer().isRedstoneEnabled()) {
                return 0;
            }
            if (!this.isLocked()) {
                Location pos = this.getLocation();
                boolean shouldBePowered = this.shouldBePowered();
                if (this.isPowered && !shouldBePowered) {
                    this.level.setBlock((Vector3)pos, this.getUnpowered(), true, true);
                    Block side = this.getSide(this.getFacing().getOpposite());
                    side.onUpdate(6);
                    RedstoneComponent.updateAroundRedstone((Position)side, new BlockFace[0]);
                } else if (!this.isPowered) {
                    this.level.setBlock((Vector3)pos, this.getPowered(), true, true);
                    Block side = this.getSide(this.getFacing().getOpposite());
                    side.onUpdate(6);
                    RedstoneComponent.updateAroundRedstone((Position)side, new BlockFace[0]);
                    if (!shouldBePowered) {
                        this.level.scheduleUpdate(this.getPowered(), this, this.getDelay());
                    }
                }
            }
        } else if (type == 1 || type == 6) {
            if (type == 1 && !this.isSupportValid(this.down())) {
                this.level.useBreakOn(this);
                return 1;
            }
            if (this.level.getServer().isRedstoneEnabled()) {
                RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
                this.getLevel().getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return 0;
                }
                this.updateState();
                return type;
            }
        }
        return 0;
    }

    public void updateState() {
        if (!this.isLocked()) {
            boolean shouldPowered = this.shouldBePowered();
            if ((this.isPowered && !shouldPowered || !this.isPowered && shouldPowered) && !this.level.isBlockTickPending(this, this)) {
                this.level.scheduleUpdate(this, this, this.getDelay());
            }
        }
    }

    public boolean isLocked() {
        return false;
    }

    protected int calculateInputStrength() {
        BlockFace face = this.getFacing();
        Position pos = this.getLocation().getSide(face);
        int power = this.level.getRedstonePower(pos, face);
        if (power >= 15) {
            return power;
        }
        Block block = this.level.getBlock(pos);
        return Math.max(power, block.getId() == 55 ? block.getDamage() : 0);
    }

    protected int getPowerOnSides() {
        Location pos = this.getLocation();
        BlockFace face = this.getFacing();
        BlockFace face1 = face.rotateY();
        BlockFace face2 = face.rotateYCCW();
        return Math.max(this.getPowerOnSide(((Vector3)pos).getSide(face1), face1), this.getPowerOnSide(((Vector3)pos).getSide(face2), face2));
    }

    protected int getPowerOnSide(Vector3 pos, BlockFace side) {
        Block block = this.level.getBlock(pos);
        return this.isAlternateInput(block) ? (block.getId() == 152 ? 15 : (block.getId() == 55 ? block.getDamage() : this.level.getStrongPower(pos, side))) : 0;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    protected boolean shouldBePowered() {
        return this.calculateInputStrength() > 0;
    }

    public abstract BlockFace getFacing();

    protected abstract int getDelay();

    protected abstract Block getUnpowered();

    protected abstract Block getPowered();

    @Override
    public double getMaxY() {
        return this.y + 0.125;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    protected boolean isAlternateInput(Block block) {
        return block.isPowerSource();
    }

    public static boolean isDiode(Block block) {
        return block instanceof BlockRedstoneDiode;
    }

    protected int getRedstoneSignal() {
        return 15;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return this.getWeakPower(side);
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return !this.isPowered() ? 0 : (this.getFacing() == side ? this.getRedstoneSignal() : 0);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isFacingTowardsRepeater() {
        BlockFace side = this.getFacing().getOpposite();
        Block block = this.getSide(side);
        return block instanceof BlockRedstoneDiode && ((BlockRedstoneDiode)block).getFacing() != side;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 0.125, this.z + 1.0);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }
}

