/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.event.block.BlockExplosionPrimeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.Explosion;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.TextFormat;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockRespawnAnchor
extends BlockMeta {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final IntBlockProperty RESPAWN_ANCHOR_CHARGE = new IntBlockProperty("respawn_anchor_charge", true, 4);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(RESPAWN_ANCHOR_CHARGE);

    @Override
    public int getId() {
        return 527;
    }

    @PowerNukkitOnly
    public BlockRespawnAnchor() {
        this(0);
    }

    @PowerNukkitOnly
    @Since(value="1.6.0.0-PN")
    public BlockRespawnAnchor(int meta) throws InvalidBlockPropertyMetaException {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Respawn Anchor";
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        int charge = this.getCharge();
        if (item.getBlockId() == 89 && charge < RESPAWN_ANCHOR_CHARGE.getMaxValue()) {
            if (player == null || !player.isCreative()) {
                --item.count;
            }
            this.setCharge(charge + 1);
            this.getLevel().setBlock(this, this);
            this.getLevel().addSound(this, Sound.RESPAWN_ANCHOR_CHARGE);
            return true;
        }
        if (player == null) {
            return false;
        }
        if (charge > 0) {
            return this.attemptToSetSpawn(player);
        }
        return false;
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    protected boolean attemptToSetSpawn(@Nonnull Player player) {
        if (this.level.getDimension() != 1) {
            if (this.level.getGameRules().getBoolean(GameRule.TNT_EXPLODES)) {
                this.explode();
            }
            return true;
        }
        if (Objects.equals(player.getSpawnBlock(), this)) {
            return false;
        }
        player.setSpawnBlock(this);
        player.setSpawn(player);
        this.getLevel().addSound(this, Sound.RESPAWN_ANCHOR_SET_SPAWN);
        player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.respawn_anchor.respawnSet"));
        return true;
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void explode() {
        BlockExplosionPrimeEvent event = new BlockExplosionPrimeEvent(this, 5.0);
        event.setIncendiary(true);
        if (event.isCancelled()) {
            return;
        }
        this.level.setBlock(this, BlockRespawnAnchor.get(0));
        Explosion explosion = new Explosion((Position)this, event.getForce(), this);
        explosion.setFireChance(event.getFireChance());
        if (event.isBlockBreaking()) {
            explosion.explodeA();
        }
        explosion.explodeB();
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getCharge() {
        return this.getIntValue(RESPAWN_ANCHOR_CHARGE);
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setCharge(int charge) {
        this.setIntValue(RESPAWN_ANCHOR_CHARGE, charge);
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getToolTier() {
        return 5;
    }

    @Override
    public double getResistance() {
        return 1200.0;
    }

    @Override
    public double getHardness() {
        return 50.0;
    }

    @Override
    public int getLightLevel() {
        switch (this.getCharge()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 7;
            }
        }
        return 15;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 3) {
            this.getLevel().addSound(this, Sound.RESPAWN_ANCHOR_DEPLETE);
            return type;
        }
        return super.onUpdate(type);
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    @PowerNukkitOnly
    public boolean canBePulled() {
        return false;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (this.canHarvest(item)) {
            return new Item[]{Item.getBlock(this.getId())};
        }
        return Item.EMPTY_ARRAY;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.BLACK_BLOCK_COLOR;
    }
}

