/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntitySkull;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemSkull;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit"), @PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN")})
public class BlockSkull
extends BlockTransparentMeta
implements RedstoneComponent,
BlockEntityHolder<BlockEntitySkull> {
    @Deprecated
    @DeprecationDetails(since="1.6.0.0-PN", reason="Mojang removed from Minecraft 1.18.10")
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BooleanBlockProperty NO_DROP = new BooleanBlockProperty("no_drop_bit", false);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.FACING_DIRECTION);

    public BlockSkull() {
        this(0);
    }

    public BlockSkull(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 144;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Skull";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntitySkull> getBlockEntityClass() {
        return BlockEntitySkull.class;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    public String getName() {
        BlockEntitySkull blockEntity;
        int itemMeta = 0;
        if (this.level != null && (blockEntity = (BlockEntitySkull)this.getBlockEntity()) != null) {
            itemMeta = blockEntity.namedTag.getByte("SkullType");
        }
        return ItemSkull.getItemSkullName(itemMeta);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        switch (face) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: 
            case UP: {
                this.setDamage(face.getIndex());
                break;
            }
            default: {
                return false;
            }
        }
        CompoundTag nbt = new CompoundTag().putByte("SkullType", item.getDamage()).putByte("Rot", (int)Math.floor(player.yaw * 16.0 / 360.0 + 0.5) & 0xF);
        if (item.hasCustomBlockData()) {
            for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                nbt.put(aTag.getName(), aTag);
            }
        }
        return BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt, new Object[0]) != null;
    }

    @Override
    @PowerNukkitDifference(info="Using new method for checking if powered", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type != 6 && type != 1 || !this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        BlockEntitySkull entity = (BlockEntitySkull)this.getBlockEntity();
        if (entity == null || entity.namedTag.getByte("SkullType") != 5) {
            return 0;
        }
        RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
        this.getLevel().getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return 0;
        }
        entity.setMouthMoving(this.isGettingPower());
        return 6;
    }

    @Override
    public Item[] getDrops(Item item) {
        BlockEntitySkull entitySkull = (BlockEntitySkull)this.getBlockEntity();
        int dropMeta = 0;
        if (entitySkull != null) {
            dropMeta = entitySkull.namedTag.getByte("SkullType");
        }
        return new Item[]{new ItemSkull((Integer)dropMeta)};
    }

    @Override
    public Item toItem() {
        BlockEntitySkull blockEntity = (BlockEntitySkull)this.getBlockEntity();
        int itemMeta = 0;
        if (blockEntity != null) {
            itemMeta = blockEntity.namedTag.getByte("SkullType");
        }
        return new ItemSkull((Integer)itemMeta);
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    @PowerNukkitOnly
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public boolean sticksToPiston() {
        return false;
    }
}

