/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBubbleColumn;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockFormEvent;
import cn.nukkit.utils.BlockColor;

public class BlockSoulSand
extends BlockSolid {
    @Override
    public String getName() {
        return "Soul Sand";
    }

    @Override
    public int getId() {
        return 88;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed MaxY BB, soul sand is a normal full cube in Bedrock Edition")
    public double getMaxY() {
        return this.y + 1.0;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public boolean isSoulSpeedCompatible() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.motionX *= 0.4;
        entity.motionZ *= 0.4;
    }

    @Override
    public int onUpdate(int type) {
        BlockFormEvent event;
        Block up;
        if (type == 1 && (up = this.up()) instanceof BlockWater && (up.getDamage() == 0 || up.getDamage() == 8) && !(event = new BlockFormEvent(up, new BlockBubbleColumn(0))).isCancelled()) {
            if (event.getNewState().getWaterloggingLevel() > 0) {
                this.getLevel().setBlock(up, 1, new BlockWater(), true, false);
            }
            this.getLevel().setBlock(up, 0, event.getNewState(), true, true);
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.BROWN_BLOCK_COLOR;
    }
}

